package cn.chiship.sdk.framework.velocity;


import cn.chiship.sdk.core.util.JdbcUtil;
import cn.chiship.sdk.core.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.ObjectUtils;
import org.apache.velocity.VelocityContext;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 代码生成类.
 *
 * @author lijian
 */
public class MybatisGeneratorTools {

    /**
     * generatorConfig模板路径
     */
    private static String generatorConfig_vm = "/template/generatorConfig.vm";
    /**
     * Service模板路径
     */
    private static String service_vm = "/template/Service.vm";
    /**
     * ServiceImpl模板路径
     */
    private static String serviceImpl_vm = "/template/ServiceImpl.vm";
    /**
     * Controller模板路径
     */
    private static String controller_vm = "/template/Controller.vm";

    /**
     * Pojo.Dto模板路径
     */
    private static String dto_vm = "/template/Dto.vm";

    /**
     * Vue模板路径
     */
    private static String web_vue_vm = "/template/Web.Vue.vm";

    /**
     * Vue Service模板路径
     */
    private static String web_service_vm = "/template/Web.Service.vm";

    /**
     * 根据模板生成generatorConfig.xml文件
     *
     * @param jdbcDriver   驱动路径
     * @param jdbcUrl      链接
     * @param jdbcUsername 帐号
     * @param jdbcPassword 密码
     * @param database     数据库
     * @param tablePrefix  表前缀
     * @param packageName  包名
     */
    public static void generator(
            String jdbcDriver,
            String jdbcUrl,
            String jdbcUsername,
            String jdbcPassword,
            String database,
            String tablePrefix,
            String packageName,
            Map<String, String> lastInsertIdTables) throws Exception {
        /**
         * 数据库类型   1 sqlserver  2 mysql
         */
        int databaseType = 1;

        if (jdbcDriver.indexOf("sqlserver") > -1) {
            databaseType = 1;
        }
        if (jdbcDriver.indexOf("mysql") > -1) {
            databaseType = 2;
        }

        String os = System.getProperty("os.name");
        String basePath = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "");
        String systemName = "win";
        if (os.toLowerCase().startsWith(systemName)) {
            generatorConfig_vm = MybatisGeneratorTools.class.getResource(generatorConfig_vm).getPath().replaceFirst("/", "");
            service_vm = MybatisGeneratorTools.class.getResource(service_vm).getPath().replaceFirst("/", "");
            System.out.println(service_vm);
            serviceImpl_vm = MybatisGeneratorTools.class.getResource(serviceImpl_vm).getPath().replaceFirst("/", "");
            controller_vm = MybatisGeneratorTools.class.getResource(controller_vm).getPath().replaceFirst("/", "");
            dto_vm = MybatisGeneratorTools.class.getResource(dto_vm).getPath().replaceFirst("/", "");
            web_vue_vm = MybatisGeneratorTools.class.getResource(web_vue_vm).getPath().replaceFirst("/", "");
            web_service_vm = MybatisGeneratorTools.class.getResource(web_service_vm).getPath().replaceFirst("/", "");

            basePath = basePath.replaceFirst("/", "");
        } else {
            generatorConfig_vm = MybatisGeneratorTools.class.getResource(generatorConfig_vm).getPath();
            service_vm = MybatisGeneratorTools.class.getResource(service_vm).getPath();
            serviceImpl_vm = MybatisGeneratorTools.class.getResource(serviceImpl_vm).getPath();
            controller_vm = MybatisGeneratorTools.class.getResource(controller_vm).getPath();
            dto_vm = MybatisGeneratorTools.class.getResource(dto_vm).getPath();
            web_vue_vm = MybatisGeneratorTools.class.getResource(web_vue_vm).getPath();
            web_service_vm = MybatisGeneratorTools.class.getResource(web_service_vm).getPath();

        }

        String generatorConfigXml = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "") + "/src/main/resources/generatorConfig.xml";
        String sql = null;
        if (1 == databaseType) {
            sql = "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_catalog = '" + database + "' AND  table_name LIKE '" + tablePrefix + "';";
        }
        if (2 == databaseType) {
            sql = "SELECT table_name,table_comment FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database + "' AND table_name LIKE '" + tablePrefix + "';";
        }
        System.out.println("========== 开始生成generatorConfig.xml文件 ==========");
        List<Map<String, Object>> tables = new ArrayList<Map<String, Object>>();
        try {
            VelocityContext context = new VelocityContext();
            Map<String, Object> table;

            // 查询定制前缀项目的所有表
            JdbcUtil jdbcUtil = new JdbcUtil(jdbcDriver, jdbcUrl, jdbcUsername, jdbcPassword);
            System.out.println(sql);
            List<Map> result = jdbcUtil.selectByParams(sql, null);


            for (Map map : result) {
                System.out.println(map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"));
                table = new HashMap<String, Object>(2);
                table.put("table_name", map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"));
                table.put("table_comment", map.get("table_comment") == null ? table.get("table_name") : map.get("table_comment"));
                table.put("model_name", StringUtil.lineToHump(ObjectUtils.toString(map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"))));

                if (map.get("table_name") != null) {
                    String columnsSql = null;
                    if (1 == databaseType) {
                        columnsSql = "SELECT *  FROM INFORMATION_SCHEMA.columns WHERE TABLE_CATALOG='" + database + "' and TABLE_NAME='" + (map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name")) + "'";
                    }
                    if (2 == databaseType) {
                        columnsSql = "SELECT * FROM INFORMATION_SCHEMA.columns WHERE  table_schema='" + database + "' and table_name='" + (map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name")) + "'";
                    }
                    JdbcUtil jdbcUtilCol = new JdbcUtil(jdbcDriver, jdbcUrl, jdbcUsername, jdbcPassword);
                    System.out.println(columnsSql);
                    List<Map> columnResults = jdbcUtilCol.selectByParams(columnsSql, null);
                    List<JSONObject> columns = new LinkedList<>();
                    for (Map item : columnResults) {
                        JSONObject columnJSON = new JSONObject();
                        columnJSON.put("name", StringUtil.toLowerCaseFirstOne(
                                StringUtil.lineToHump(
                                        ObjectUtils.toString(item.get("column_name") == null ? item.get("COLUMN_NAME") : item.get("column_name"))
                                )
                        ));
                        if (item.containsKey("column_comment") || item.containsKey("column_comment")) {
                            columnJSON.put("comment", StringUtil.toLowerCaseFirstOne(
                                    StringUtil.lineToHump(
                                            ObjectUtils.toString(item.get("column_comment") == null ? item.get("COLUMN_COMMENT") : item.get("column_comment"))
                                    )
                            ));
                        } else {
                            columnJSON.put("comment", StringUtil.toLowerCaseFirstOne(
                                    StringUtil.lineToHump(
                                            ObjectUtils.toString(item.get("column_name") == null ? item.get("COLUMN_NAME") : item.get("column_name"))
                                    )
                            ));
                        }

                        columns.add(columnJSON);
                    }
                    table.put("columns", columns);
                    jdbcUtilCol.release();
                }


                tables.add(table);
            }
            jdbcUtil.release();
            String targetProject = basePath;
            String targetProjectSqlMap = basePath;
            context.put("tables", tables);
            context.put("generator_javaModelGenerator_targetPackage", packageName + ".entity");
            context.put("generator_sqlMapGenerator_targetPackage", packageName + ".mapper");
            context.put("generator_javaClientGenerator_targetPackage", packageName + ".mapper");
            context.put("targetProject", targetProject);
            context.put("targetProject_sqlMap", targetProjectSqlMap);
            context.put("generator_jdbc_password", jdbcPassword);
            context.put("last_insert_id_tables", lastInsertIdTables);
            VelocityUtil.generate(generatorConfig_vm, generatorConfigXml, context);
            // 删除旧代码
            //deleteDir(new File(targetProject + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/mapper/model"));
            //deleteDir(new File(targetProject + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/mapper/mapper"));
            for (int i = 0; i < tables.size(); i++) {
                String model = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_name")));
                deleteDir(new File(targetProjectSqlMap + "/src/main/resources/" + packageName.replaceAll("\\.", "/") + "/mapper/" + model + "Mapper.xml"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("========== 结束生成generatorConfig.xml文件 ==========");

        System.out.println("========== 开始运行MybatisGenerator ==========");
        List<String> warnings = new ArrayList<String>();
        File configFile = new File(generatorConfigXml);
        ConfigurationParser cp = new ConfigurationParser(warnings);
        Configuration config = cp.parseConfiguration(configFile);
        DefaultShellCallback callback = new DefaultShellCallback(true);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
        myBatisGenerator.generate(null);
        for (String warning : warnings) {
            System.out.println(warning);
        }
        System.out.println("========== 结束运行MybatisGenerator ==========");

        System.out.println("========== 开始生成Service ==========");
        String ctime = new SimpleDateFormat("yyyy/M/d").format(new Date());
        String servicePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service";
        String serviceImplPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service/impl";
        // 如果文件夹不存在，创建文件夹
        createDir(new File(servicePath));
        createDir(new File(serviceImplPath));
        for (int i = 0; i < tables.size(); i++) {
            String model = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_comment")));

            String service = servicePath + "/" + model + "Service.java";
            String serviceImpl = serviceImplPath + "/" + model + "ServiceImpl.java";
            VelocityContext context = commonContext(packageName, model, modelName, ctime);
            File serviceFile = new File(service);
            if (!serviceFile.exists()) {
                VelocityUtil.generate(service_vm, service, context);
                System.out.println(service);
            }
            File serviceImplFile = new File(serviceImpl);
            if (!serviceImplFile.exists()) {
                context.put("mapper", StringUtil.toLowerCaseFirstOne(model));
                VelocityUtil.generate(serviceImpl_vm, serviceImpl, context);
                System.out.println(serviceImpl);
            }
        }
        System.out.println("========== 结束生成Service ==========");

        System.out.println("========== 开始生成Controller ==========");
        String controllerPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/controller";
        // 如果文件夹不存在，创建文件夹
        createDir(new File(controllerPath));
        for (int i = 0; i < tables.size(); i++) {
            String model = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_comment")));
            String controller = controllerPath + "/" + model + "Controller.java";
            VelocityContext context = commonContext(packageName, model, modelName, ctime);
            File serviceFile = new File(controller);
            if (!serviceFile.exists()) {
                VelocityUtil.generate(controller_vm, controller, context);
                System.out.println(controller);
            }
        }
        System.out.println("========== 结束生成Controller ==========");

        System.out.println("========== 开始生成Dto ==========");
        String dtoPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/pojo/dto";
        // 如果文件夹不存在，创建文件夹
        createDir(new File(dtoPath));
        for (int i = 0; i < tables.size(); i++) {
            String model = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_comment")));
            String dto = dtoPath + "/" + model + "Dto.java";
            VelocityContext context = commonContext(packageName, model, modelName, ctime);
            File dtoFile = new File(dto);
            if (!dtoFile.exists()) {
                VelocityUtil.generate(dto_vm, dto, context);
                System.out.println(dto);
            }
        }
        System.out.println("========== 结束生成Dto ==========");

        System.out.println("========== 开始生成Vue相关 ==========");
        String webVuePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/vue/vue";
        String webServicePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/vue/js";
        // 如果文件夹不存在，创建文件夹
        createDir(new File(webVuePath));
        createDir(new File(webServicePath));
        for (int i = 0; i < tables.size(); i++) {
            String model = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump(ObjectUtils.toString(tables.get(i).get("table_comment")));
            List<JSONObject> columns = (List<JSONObject>) tables.get(i).get("columns");
            System.out.println(JSONObject.toJSON(columns));
            VelocityContext context = commonContext(packageName, model, modelName, ctime);
            context.put("columns", columns);
            String vue = webVuePath + "/" + StringUtil.toLowerCaseFirstOne(model) + ".vue";
            File webVueFile = new File(vue);
            if (!webVueFile.exists()) {
                VelocityUtil.generate(web_vue_vm, vue, context);
                System.out.println(vue);
            }

            String vueService = webServicePath + "/" + model + "Service.js";
            File webServiceFile = new File(vueService);
            if (!webServiceFile.exists()) {
                VelocityUtil.generate(web_service_vm, vueService, context);
                System.out.println(vueService);
            }
        }
        System.out.println("========== 结束生成Vue相关 ==========");
    }

    private static VelocityContext commonContext(String packageName, String model, String modelName, String ctime) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("packageName", packageName);
        context.put("ClassName", model);
        context.put("className", StringUtil.toLowerCaseFirstOne(model));
        context.put("ctime", ctime);
        context.put("modelName", modelName);

        return context;
    }

    /**
     * 递归删除非空文件夹
     *
     * @param dir
     */
    public static void deleteDir(File dir) {
        System.out.println("删除路径：" + dir.getPath());
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; i++) {
                deleteDir(files[i]);
            }
        }
        dir.delete();
    }

    /**
     * 递归创建空文件夹
     *
     * @param dir
     */
    public static void createDir(File dir) {
        if (!dir.exists()) {
            if (dir.getParentFile().exists()) {
                dir.mkdir();
            } else {
                createDir(dir.getParentFile());
                dir.mkdir();
            }
        }
    }

}
