package cn.chiship.sdk.framework.validator;

import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;

import java.util.regex.Pattern;

/**
 * 数字字符串检查（包含符号','）
 *
 * @author lijian
 */
public class NumericStringValidator extends ValidatorHandler<String> implements Validator<String> {

    private String fieldName;

    public NumericStringValidator(String fieldName) {

        this.fieldName = fieldName;

    }

    @Override
    public boolean validate(ValidatorContext context, String s) {

        String reg = "^[1-9][0-9]*(,?([1-9][0-9]*,?))*$";
        if(!Pattern.compile(reg).matcher(s).matches()) {
            context.addError(ValidationError.create(String.format("%s只能包含数字和符号','", fieldName))
                    .setErrorCode(-1)
                    .setField(fieldName)
                    .setInvalidValue(s));
            return false;
        }
        return true;

    }
}
