package cn.chiship.sdk.framework.validator;

import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;

import java.util.regex.Pattern;

/**
 * 纬度检查
 *
 * @author lijian
 */
public class LatValidator extends ValidatorHandler<String> implements Validator<String> {

    /**
     * 精确度位数
     */
    private int len;

    /**
     * 字段名称
     */
    private String fieldName;

    public LatValidator(int len, String fieldName) {
        this.len = len;
        this.fieldName = fieldName;
    }

    @Override
    public boolean validate(ValidatorContext context, String s) {

        String reg = "^[\\-\\+]?([0-8]?\\d{1}\\.\\d{1," + len + "}|90\\.0{1," + len +"})$";
        if(!Pattern.compile(reg).matcher(s).matches()) {
            context.addError(ValidationError.create(String.format("%s不符合参数要求！", fieldName))
                    .setErrorCode(-1)
                    .setField(fieldName)
                    .setInvalidValue(s));
            return false;
        }
        return true;

    }
}
