package cn.chiship.sdk.framework.mybatis.plugin;

import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.*;

import java.util.List;
import java.util.Properties;

/**
 * Example类和model类实现序列化插件
 * @author jianhun
 * @date 2018/5/22
 */
public class SerializablePlugin extends PluginAdapter {

    private FullyQualifiedJavaType serializable =
            new FullyQualifiedJavaType("java.io.Serializable");

    private FullyQualifiedJavaType gwtSerializable =
            new FullyQualifiedJavaType("com.google.gwt.user.client.rpc.IsSerializable");

    private boolean addGWTInterface;

    private boolean suppressJavaInterface;

    public SerializablePlugin() {

    }

    @Override
    public boolean validate(List<String> warnings) {

        return true;

    }

    @Override
    public void setProperties(Properties properties) {

        super.setProperties(properties);
        this.addGWTInterface = Boolean.valueOf(properties.getProperty("addGWTInterface")).booleanValue();
        this.suppressJavaInterface = Boolean.valueOf(properties.getProperty("suppressJavaInterface")).booleanValue();

    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        this.makeSerializable(topLevelClass, introspectedTable);
        return true;

    }

    @Override
    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        this.makeSerializable(topLevelClass, introspectedTable);
        return true;

    }

    @Override
    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass,
                                                      IntrospectedTable introspectedTable) {

        this.makeSerializable(topLevelClass, introspectedTable);
        return true;

    }

    protected void makeSerializable(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        if(this.addGWTInterface) {
            topLevelClass.addImportedType(this.gwtSerializable);
            topLevelClass.addSuperInterface(this.gwtSerializable);
        }

        if(!this.suppressJavaInterface) {
            topLevelClass.addImportedType(this.serializable);
            topLevelClass.addSuperInterface(this.serializable);
            Field field = new Field();
            field.setFinal(true);
            field.setInitializationString("1L");
            field.setName("serialVersionUID");
            field.setStatic(true);
            field.setType(new FullyQualifiedJavaType("long"));
            field.setVisibility(JavaVisibility.PRIVATE);
            this.context.getCommentGenerator().addFieldComment(field, introspectedTable);
            topLevelClass.addField(field);
        }

    }

    /**
     * 添加给Example类序列化的方法
     * @param topLevelClass
     * @param introspectedTable
     * @return
     */
    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass,IntrospectedTable introspectedTable){

        makeSerializable(topLevelClass, introspectedTable);
        for (InnerClass innerClass : topLevelClass.getInnerClasses()) {
            if ("GeneratedCriteria".equals(innerClass.getType().getShortName())) {
                innerClass.addSuperInterface(serializable);
            }

            if ("Criteria".equals(innerClass.getType().getShortName())) {
                innerClass.addSuperInterface(serializable);
            }

            if ("Criterion".equals(innerClass.getType().getShortName())) {
                innerClass.addSuperInterface(serializable);
            }
        }
        return true;

    }

}
