package cn.chiship.sdk.framework.base;


import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.framework.pojo.vo.PageVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author lj
 * 2018-05-17
 */
public interface BaseService<Record, Example> {

    /**
     * 插入记录有效字段
     *
     * @param record 插入数据的实体
     * @return
     */
    BaseResult insertSelective(Record record);

    /**
     * 根据条件删除记录
     *
     * @param example 删除记录条件
     * @return
     */
    BaseResult deleteByExample(Example example);

    /**
     * 根据主键删除记录
     *
     * @param id 主键
     * @return
     */
    BaseResult deleteByPrimaryKey(Object id);

    /**
     * 根据条件更新有效字段
     *
     * @param record  实体
     * @param example 条件
     * @return
     */
    BaseResult updateByExampleSelective(Record record, Example example);


    /**
     * 根据主键更新记录有效字段
     *
     * @param record 实体
     * @return
     */
    BaseResult updateByPrimaryKeySelective(Record record);


    /**
     * 根据条件查询记录
     *
     * @param example 条件
     * @return
     */
    List<Record> selectByExample(Example example);


    /**
     * 根据主键查询记录
     *
     * @param id 主键
     * @return
     */
    Record selectByPrimaryKey(Object id);

    /**
     * 根据主键查找记录详情
     *
     * @param id
     * @return
     */
    BaseResult selectDetailsByPrimaryKey(Object id);

    /**
     * 根据条件查询记录数量
     *
     * @param example 条件
     * @return
     */
    long countByExample(Example example);


    /**
     * 分页
     *
     * @param pageVo  分页对象
     * @param example 条件
     * @return
     */
    PageVo selectPageByExample(PageVo pageVo, Example example, String sort);


    /**
     * 导出
     *
     * @param response
     * @param paramMap
     * @throws Exception
     */
    void exportData(HttpServletResponse response, Map<String, Object> paramMap) throws Exception;

    /**
     * 根据字段校验数据是否存在
     *
     * @param id    主键
     * @param field 字段名
     * @param value 字段值
     * @return
     */
    BaseResult validateExistByField(String id, String field, String value);
}
