/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.velocity;

import cn.chiship.sdk.core.util.JdbcUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.velocity.VelocityUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.velocity.VelocityContext;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;

public class MybatisGeneratorTools {
    private static String generatorConfig_vm = "/template/generatorConfig.vm";
    private static String service_vm = "/template/Service.vm";
    private static String serviceImpl_vm = "/template/ServiceImpl.vm";
    private static String controller_vm = "/template/Controller.vm";

    public static void generator(String jdbcDriver, String jdbcUrl, String jdbcUsername, String jdbcPassword, String database, String tablePrefix, String packageName, Map<String, String> lastInsertIdTables) throws Exception {
        File serviceFile;
        VelocityContext context;
        int databaseType = 1;
        if (jdbcDriver.indexOf("sqlserver") > -1) {
            databaseType = 1;
        }
        if (jdbcDriver.indexOf("mysql") > -1) {
            databaseType = 2;
        }
        String os = System.getProperty("os.name");
        String basePath = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "");
        String systemName = "win";
        if (os.toLowerCase().startsWith(systemName)) {
            generatorConfig_vm = MybatisGeneratorTools.class.getResource(generatorConfig_vm).getPath().replaceFirst("/", "");
            service_vm = MybatisGeneratorTools.class.getResource(service_vm).getPath().replaceFirst("/", "");
            System.out.println(service_vm);
            serviceImpl_vm = MybatisGeneratorTools.class.getResource(serviceImpl_vm).getPath().replaceFirst("/", "");
            controller_vm = MybatisGeneratorTools.class.getResource(controller_vm).getPath().replaceFirst("/", "");
            basePath = basePath.replaceFirst("/", "");
        } else {
            generatorConfig_vm = MybatisGeneratorTools.class.getResource(generatorConfig_vm).getPath();
            service_vm = MybatisGeneratorTools.class.getResource(service_vm).getPath();
            serviceImpl_vm = MybatisGeneratorTools.class.getResource(serviceImpl_vm).getPath();
            controller_vm = MybatisGeneratorTools.class.getResource(controller_vm).getPath();
        }
        String generatorConfigXml = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "") + "/src/main/resources/generatorConfig.xml";
        String sql = null;
        if (1 == databaseType) {
            sql = "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_catalog = '" + database + "' AND  table_name LIKE '" + tablePrefix + "';";
        }
        if (2 == databaseType) {
            sql = "SELECT table_name,table_comment FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database + "' AND table_name LIKE '" + tablePrefix + "';";
        }
        System.out.println("========== \u5f00\u59cb\u751f\u6210generatorConfig.xml\u6587\u4ef6 ==========");
        ArrayList tables = new ArrayList();
        try {
            VelocityContext context2 = new VelocityContext();
            JdbcUtil jdbcUtil = new JdbcUtil(jdbcDriver, jdbcUrl, jdbcUsername, jdbcPassword);
            System.out.println(sql);
            List result = jdbcUtil.selectByParams(sql, null);
            for (Map map : result) {
                System.out.println(map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"));
                HashMap table = new HashMap(2);
                table.put("table_name", map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"));
                table.put("table_comment", map.get("table_comment") == null ? table.get("table_name") : map.get("table_comment"));
                table.put("model_name", StringUtil.lineToHump((String)ObjectUtils.toString(map.get("table_name") == null ? map.get("TABLE_NAME") : map.get("table_name"))));
                tables.add(table);
            }
            jdbcUtil.release();
            String targetProject = basePath;
            String targetProjectSqlMap = basePath;
            context2.put("tables", tables);
            context2.put("generator_javaModelGenerator_targetPackage", (Object)(packageName + ".entity"));
            context2.put("generator_sqlMapGenerator_targetPackage", (Object)(packageName + ".mapper"));
            context2.put("generator_javaClientGenerator_targetPackage", (Object)(packageName + ".mapper"));
            context2.put("targetProject", (Object)targetProject);
            context2.put("targetProject_sqlMap", (Object)targetProjectSqlMap);
            context2.put("generator_jdbc_password", (Object)jdbcPassword);
            context2.put("last_insert_id_tables", lastInsertIdTables);
            VelocityUtil.generate(generatorConfig_vm, generatorConfigXml, context2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("========== \u7ed3\u675f\u751f\u6210generatorConfig.xml\u6587\u4ef6 ==========");
        System.out.println("========== \u5f00\u59cb\u8fd0\u884cMybatisGenerator ==========");
        ArrayList warnings = new ArrayList();
        File configFile = new File(generatorConfigXml);
        ConfigurationParser cp = new ConfigurationParser(warnings);
        Configuration config = cp.parseConfiguration(configFile);
        DefaultShellCallback callback = new DefaultShellCallback(true);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
        myBatisGenerator.generate(null);
        for (String warning : warnings) {
            System.out.println(warning);
        }
        System.out.println("========== \u7ed3\u675f\u8fd0\u884cMybatisGenerator ==========");
        System.out.println("========== \u5f00\u59cb\u751f\u6210Service ==========");
        String ctime = new SimpleDateFormat("yyyy/M/d").format(new Date());
        String servicePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service";
        String serviceImplPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service/impl";
        MybatisGeneratorTools.createDir(new File(servicePath));
        MybatisGeneratorTools.createDir(new File(serviceImplPath));
        for (int i = 0; i < tables.size(); ++i) {
            File serviceImplFile;
            String model = StringUtil.lineToHump((String)ObjectUtils.toString(((Map)tables.get(i)).get("table_name")));
            String modelName = StringUtil.lineToHump((String)ObjectUtils.toString(((Map)tables.get(i)).get("table_comment")));
            String service = servicePath + "/" + model + "Service.java";
            String serviceImpl = serviceImplPath + "/" + model + "ServiceImpl.java";
            context = MybatisGeneratorTools.createServiceOrMockOrImplOrController(packageName, model, modelName, ctime);
            serviceFile = new File(service);
            if (!serviceFile.exists()) {
                VelocityUtil.generate(service_vm, service, context);
                System.out.println(service);
            }
            if ((serviceImplFile = new File(serviceImpl)).exists()) continue;
            context.put("mapper", (Object)StringUtil.toLowerCaseFirstOne((String)model));
            VelocityUtil.generate(serviceImpl_vm, serviceImpl, context);
            System.out.println(serviceImpl);
        }
        System.out.println("========== \u7ed3\u675f\u751f\u6210Service ==========");
        System.out.println("========== \u5f00\u59cb\u751f\u6210Controller ==========");
        String controllerPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/controller";
        for (int i = 0; i < tables.size(); ++i) {
            String model = StringUtil.lineToHump((String)ObjectUtils.toString(((Map)tables.get(i)).get("table_name")));
            String modelName = StringUtil.lineToHump((String)ObjectUtils.toString(((Map)tables.get(i)).get("table_comment")));
            String controller = controllerPath + "/" + model + "Controller.java";
            context = MybatisGeneratorTools.createServiceOrMockOrImplOrController(packageName, model, modelName, ctime);
            serviceFile = new File(controller);
            if (serviceFile.exists()) continue;
            context.put("service", (Object)StringUtil.toLowerCaseFirstOne((String)model));
            VelocityUtil.generate(controller_vm, controller, context);
            System.out.println(controller);
        }
        System.out.println("========== \u7ed3\u675f\u751f\u6210Controller ==========");
    }

    private static VelocityContext createServiceOrMockOrImplOrController(String packageName, String model, String modelName, String ctime) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("package_name", (Object)packageName);
        context.put("model", (Object)model);
        context.put("ctime", (Object)ctime);
        context.put("modelName", (Object)modelName);
        return context;
    }

    public static void deleteDir(File dir) {
        System.out.println(dir.getPath());
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                MybatisGeneratorTools.deleteDir(files[i]);
            }
        }
        dir.delete();
    }

    public static void createDir(File dir) {
        if (!dir.exists()) {
            if (dir.getParentFile().exists()) {
                dir.mkdir();
            } else {
                MybatisGeneratorTools.createDir(dir.getParentFile());
                dir.mkdir();
            }
        }
    }
}

