package cn.chiship.sdk.framework.properties;

import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import org.springframework.stereotype.Component;

import java.util.MissingResourceException;

/**
 * 常量配置
 *
 * @author LiJian
 */
@Component
public class CommonConstantsConfigProperties {
    private String prefix = "constants.config.";
    private static CommonConstantsConfigProperties instance;
    private static PropertiesFileUtil propertiesFileUtil;

    private CommonConstantsConfigProperties() {

    }

    static {
        try {
            propertiesFileUtil = PropertiesFileUtil.getInstance("application");
        } catch (MissingResourceException e) {
            throw new RuntimeException("兄弟,请确保'application.properties'文件存在!");
        }
    }

    public static synchronized CommonConstantsConfigProperties getInstance() {
        if (null == instance) {
            instance = new CommonConstantsConfigProperties();
        }
        return instance;
    }


    /**
     * 数据表主键生成原则
     * 生成原则：1.若主键类型为Long类型则自动使用雪花算法生成主键  2.若主键类型为String类型，则根据配置使用对应的生成原则  3.若业务层已经对主键赋值了，则忽略此配置
     * UUID         默认调用  @see cn.chiship.sdk.core.util.RandomUtil.uuidLowerCase() 方法
     * SNOWFLAKE  默认    雪花算法 默认调用  see cn.chiship.sdk.core.id.generateId() 方法
     *
     * @Value("${constants.config.tables.keyGenerator.type}")
     */
    public String getTableKeyGenerator() {
        String tableKeyGenerator = null;
        tableKeyGenerator = propertiesFileUtil.get(prefix + "tables.keyGenerator.type");
        if (StringUtil.isNullOrEmpty(tableKeyGenerator)) {
            return "SNOWFLAKE";
        }
        return tableKeyGenerator;
    }

    public static void main(String[] args) {
        getInstance().getTableKeyGenerator();
    }


}
