/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.swagger.ext.core.operation.processor;

import cn.chenzw.swagger.ext.core.util.SwaggerUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import io.swagger.annotations.ext.ApiMapParams;
import io.swagger.annotations.ext.ApiMapResponses;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=0x7FFFFFFF)
public class SwaggerMapProcessor
implements OperationBuilderPlugin {
    public void apply(OperationContext context) {
        this.processParameter(context);
        this.processResponse(context);
    }

    public boolean supports(DocumentationType documentationType) {
        return true;
    }

    private void processParameter(OperationContext context) {
        List apiMapParamsList = context.findAllAnnotations(ApiMapParams.class);
        if (apiMapParamsList != null) {
            this.removeParameterBody(context, apiMapParamsList);
            this.addParamterBody(context, apiMapParamsList);
        }
        List parameters = context.getParameters();
        for (ResolvedMethodParameter parameter : parameters) {
            Optional apiMapMethodParamsOptional = parameter.findAnnotation(ApiMapParams.class);
            if (!apiMapMethodParamsOptional.isPresent()) continue;
            ArrayList<ApiMapParams> apiMapParamsList2 = new ArrayList<ApiMapParams>(Arrays.asList((ApiMapParams)apiMapMethodParamsOptional.get()));
            this.removeParameterBody(context, apiMapParamsList2);
            this.addParamterBody(context, apiMapParamsList2);
        }
    }

    private void processResponse(OperationContext context) {
        Optional apiMapResponsesOptional = context.findAnnotation(ApiMapResponses.class);
        if (apiMapResponsesOptional.isPresent()) {
            context.operationBuilder().responseMessages((Set)Sets.newHashSet((Object[])new ResponseMessage[]{new ResponseMessage(HttpStatus.OK.value(), HttpStatus.OK.getReasonPhrase(), (ModelReference)new ModelRef(SwaggerUtils.generateModelResponseName(context.requestMappingPattern())), null, null)}));
        }
    }

    private boolean mapMatched(List<ApiMapParams> apiMapParamsList, String name) {
        for (ApiMapParams apiMapParams : apiMapParamsList) {
            if (!apiMapParams.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void removeParameterBody(OperationContext context, List<ApiMapParams> apiMapParamsList) {
        OperationBuilder operationBuilder = context.operationBuilder();
        try {
            Field paramField = OperationBuilder.class.getDeclaredField("parameters");
            paramField.setAccessible(true);
            List parameters = (List)paramField.get(operationBuilder);
            parameters.removeIf(parameter -> "body".equals(parameter.getParamType()) && this.mapMatched(apiMapParamsList, parameter.getName()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to modify parameter field!", e);
        }
    }

    private void addParamterBody(OperationContext context, List<ApiMapParams> apiMapParamsList) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (ApiMapParams apiMapParams : apiMapParamsList) {
            ResolvedMethodParameter methodParameter = this.getMethodParameter(context.getParameters(), apiMapParams.name());
            ParameterContext parameterContext = new ParameterContext(methodParameter, new ParameterBuilder(), context.getDocumentationContext(), context.getGenericsNamingStrategy(), context);
            parameters.add(parameterContext.parameterBuilder().parameterType("body").modelRef((ModelReference)new ModelRef(SwaggerUtils.generateUniqueModelName(apiMapParams.name(), context.requestMappingPattern()))).name(apiMapParams.name()).build());
        }
        context.operationBuilder().parameters(parameters);
    }

    private ResolvedMethodParameter getMethodParameter(List<ResolvedMethodParameter> methodParameters, String name) {
        for (ResolvedMethodParameter methodParameter : methodParameters) {
            Optional nameOptional = methodParameter.defaultName();
            if (!nameOptional.isPresent() || !((String)nameOptional.get()).equals(name)) continue;
            return methodParameter;
        }
        return null;
    }
}

