/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.swagger.ext.core.bean;

import cn.chenzw.swagger.ext.core.config.SwaggerProperties;
import cn.chenzw.swagger.ext.core.predicate.ClassNamesPredicate;
import com.google.common.base.Predicate;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

public class DocketFactoryBean
implements FactoryBean<Docket> {
    private String groupName;
    private Set<String> clazzNames;
    private SwaggerProperties swaggerProperties;

    public DocketFactoryBean(String groupName, Set<String> clazzNames, SwaggerProperties swaggerProperties) {
        this.groupName = groupName;
        this.clazzNames = clazzNames;
        this.swaggerProperties = swaggerProperties;
    }

    @Override
    public Docket getObject() throws Exception {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.groupName).apiInfo(this.apiInfo()).select().apis((Predicate)new ClassNamesPredicate(this.clazzNames)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).termsOfServiceUrl(this.swaggerProperties.getTermsOfServiceUrl()).version(this.swaggerProperties.getVersion()).license(this.swaggerProperties.getLicense()).licenseUrl(this.swaggerProperties.getLicenseUrl()).contact(new Contact(this.swaggerProperties.getContactName(), this.swaggerProperties.getContactUrl(), this.swaggerProperties.getContactEmail())).build();
    }

    @Override
    public Class<?> getObjectType() {
        return Docket.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

