/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sso.easy.client.support.builder;

import cn.chenzw.sso.easy.core.constants.SSOConstants;
import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SSOMetaDataBuilder {
    private String sourceIdentifier;
    private String keyIdentifier;
    private String usernameIdentifier;
    private String redirectUrlIdentifier;
    private int limitMilliSecond;

    public static SSOMetaDataBuilder create() {
        return new SSOMetaDataBuilder();
    }

    public SSOMetaDataBuilder setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
        return this;
    }

    public SSOMetaDataBuilder setKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        return this;
    }

    public SSOMetaDataBuilder setUsernameIdentifier(String usernameIdentifier) {
        this.usernameIdentifier = usernameIdentifier;
        return this;
    }

    public SSOMetaDataBuilder setRedirectUrlIdentifier(String redirectUrlIdentifier) {
        this.redirectUrlIdentifier = redirectUrlIdentifier;
        return this;
    }

    public SSOMetaDataBuilder setLimitMilliSecond(int limitMilliSecond) {
        this.limitMilliSecond = limitMilliSecond;
        return this;
    }

    public SSOMetaData build() {
        return new SSOMetaData((String)StringUtils.defaultIfBlank((CharSequence)this.sourceIdentifier, (CharSequence)SSOConstants.SOURCE_IDENTIFIER), (String)StringUtils.defaultIfBlank((CharSequence)this.keyIdentifier, (CharSequence)SSOConstants.KEY_IDENTIFIER), (String)StringUtils.defaultIfBlank((CharSequence)this.usernameIdentifier, (CharSequence)SSOConstants.USERNAME_IDENTIFIER), (String)StringUtils.defaultIfBlank((CharSequence)this.redirectUrlIdentifier, (CharSequence)SSOConstants.REDIRECT_URL_IDENTIFIER), (Integer)ObjectUtils.defaultIfNull((Object)this.limitMilliSecond, (Object)SSOConstants.LIMIT_MILLI_SECOND));
    }

    public static class SSOMetaData
    implements Serializable {
        private String sourceIdentifier;
        private String keyIdentifier;
        private String usernameIdentifier;
        private String redirectUrlIdentifier;
        private Integer limitMilliSecond;

        public SSOMetaData() {
        }

        public SSOMetaData(String sourceIdentifier, String keyIdentifier, String usernameIdentifier, String redirectUrlIdentifier, Integer limitMilliSecond) {
            this.sourceIdentifier = sourceIdentifier;
            this.keyIdentifier = keyIdentifier;
            this.usernameIdentifier = usernameIdentifier;
            this.redirectUrlIdentifier = redirectUrlIdentifier;
            this.limitMilliSecond = limitMilliSecond;
        }

        public String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        public String getUsernameIdentifier() {
            return this.usernameIdentifier;
        }

        public void setUsernameIdentifier(String usernameIdentifier) {
            this.usernameIdentifier = usernameIdentifier;
        }

        public String getRedirectUrlIdentifier() {
            return this.redirectUrlIdentifier;
        }

        public void setRedirectUrlIdentifier(String redirectUrlIdentifier) {
            this.redirectUrlIdentifier = redirectUrlIdentifier;
        }

        public Integer getLimitMilliSecond() {
            return this.limitMilliSecond;
        }

        public void setLimitMilliSecond(Integer limitMilliSecond) {
            this.limitMilliSecond = limitMilliSecond;
        }
    }
}

