/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sso.easy.client.support;

import cn.chenzw.sso.easy.client.support.builder.SSOMetaDataBuilder;
import cn.chenzw.sso.easy.client.support.entity.SSOEntity;
import cn.chenzw.sso.easy.core.constants.SSOConstants;
import cn.chenzw.sso.easy.core.exception.SSOException;
import cn.chenzw.toolkit.codec.AESUtils;
import cn.chenzw.toolkit.commons.UriExtUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SSOClient {
    public static String generateSSOUrl(String serverSSOUrl, String privateKey, String source, String userName, String redirectUrl) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put(SSOConstants.SOURCE_IDENTIFIER, source);
            paramMap.put(SSOConstants.USERNAME_IDENTIFIER, AESUtils.encryptAsHexString((String)userName, (String)privateKey));
            paramMap.put(SSOConstants.KEY_IDENTIFIER, AESUtils.encryptAsHexString((String)(userName + "##" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")), (String)privateKey));
            paramMap.put(SSOConstants.REDIRECT_URL_IDENTIFIER, URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SSOException(e.getMessage());
        }
        return UriExtUtils.buildParams((String)serverSSOUrl, paramMap);
    }

    public static String generateSSOUrl(SSOEntity ssoEntity) {
        return SSOClient.generateSSOUrl(ssoEntity.getServerSSOUrl(), ssoEntity.getPrivateKey(), ssoEntity.getSource(), ssoEntity.getUserName(), ssoEntity.getRedirectUrl());
    }

    public static String generateSSOUrl(String serverSSOUrl, String privateKey, String source, String userName, String redirectUrl, SSOMetaDataBuilder ssoMetaDataBuilder) {
        if (ssoMetaDataBuilder == null) {
            return null;
        }
        SSOMetaDataBuilder.SSOMetaData ssoMetaData = ssoMetaDataBuilder.build();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put(ssoMetaData.getSourceIdentifier(), source);
            paramMap.put(ssoMetaData.getUsernameIdentifier(), AESUtils.encryptAsHexString((String)userName, (String)privateKey));
            paramMap.put(ssoMetaData.getKeyIdentifier(), AESUtils.encryptAsHexString((String)(userName + "##" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")), (String)privateKey));
            paramMap.put(ssoMetaData.getRedirectUrlIdentifier(), URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SSOException(e.getMessage());
        }
        return UriExtUtils.buildParams((String)serverSSOUrl, paramMap);
    }

    public static String getEncrypedUserName(String userName, String privateKey) {
        try {
            return AESUtils.encryptAsHexString((String)userName, (String)privateKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SSOException(e.getMessage());
        }
    }

    public static String getEncrypedKey(String userName, String privateKey) {
        try {
            return AESUtils.encryptAsHexString((String)(userName + "##" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")), (String)privateKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SSOException(e.getMessage());
        }
    }
}

