/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.tlv;

import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;

public abstract class TLV {
    private short tag = 0;
    private boolean valueIsSet = false;
    private static int DONT_CHECK_LIMIT = -1;
    private int minLength = DONT_CHECK_LIMIT;
    private int maxLength = DONT_CHECK_LIMIT;

    public TLV() {
    }

    public TLV(short tag) {
        this.tag = tag;
    }

    public TLV(int min, int max) {
        this.minLength = min;
        this.maxLength = max;
    }

    public TLV(short tag, int min, int max) {
        this.tag = tag;
        this.minLength = min;
        this.maxLength = max;
    }

    public abstract void setValueData(byte[] var1) throws Exception;

    public abstract byte[] getValueData() throws Exception;

    public void setTag(short tag) {
        this.tag = tag;
    }

    public short getTag() {
        return this.tag;
    }

    public short getLength() {
        try {
            if (this.hasValue()) {
                byte[] valueBuf = this.getValueData();
                if (valueBuf != null) {
                    int length = valueBuf.length;
                    return (short)length;
                }
                return 0;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void fromBytes(byte[] buffer) throws Exception {
        int index = 0;
        this.fromBytes(buffer, index);
    }

    public int fromBytes(byte[] buffer, int offset) throws Exception {
        short newTag = ByteUtils.byte2short(buffer, offset);
        short length = ByteUtils.byte2short(buffer, offset += 2);
        byte[] valueBytes = new byte[length];
        System.arraycopy(buffer, offset += 2, valueBytes, 0, length);
        this.setValueData(valueBytes);
        this.setTag(newTag);
        return offset;
    }

    public byte[] toBytes() throws Exception {
        if (this.hasValue()) {
            short length = this.getLength();
            byte[] bytes = new byte[4 + length];
            this.toBytes(bytes, 0);
            return bytes;
        }
        return null;
    }

    public int toBytes(byte[] buffer, int offset) throws Exception {
        if (this.hasValue()) {
            short length = this.getLength();
            ByteUtils.short2byte(this.getTag(), buffer, offset);
            ByteUtils.short2byte(this.getLength(), buffer, offset += 2);
            byte[] valueBytes = this.getValueData();
            System.arraycopy(valueBytes, 0, buffer, offset += 2, length);
            offset += length;
        }
        return offset;
    }

    protected void markValueSet() {
        this.valueIsSet = true;
    }

    public boolean hasValue() {
        return this.valueIsSet;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TLV) {
            return this.getTag() == ((TLV)obj).getTag();
        }
        return false;
    }
}

