/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;

public class SMGPReportData {
    public static final int LENGTH = 66 + "id: sub: dlvrd: submit date: done date: stat: err: text:".length();
    private byte[] msgId = new byte[10];
    private String sub = "001";
    private String dlvrd = "001";
    private String subTime;
    private String doneTime;
    private String stat;
    private String err = "";
    private String txt = "";

    public boolean fromBytes(byte[] bytes) throws Exception {
        int offset = 0;
        byte[] tmp = null;
        this.msgId = new byte[10];
        System.arraycopy(bytes, offset += "id:".length(), this.msgId, 0, 10);
        offset += 10;
        tmp = new byte[3];
        System.arraycopy(bytes, offset += " sub:".length(), tmp, 0, 3);
        this.sub = new String(ByteUtils.rtrimBytes(tmp));
        offset += 3;
        tmp = new byte[3];
        System.arraycopy(bytes, offset += " dlvrd:".length(), tmp, 0, 3);
        this.dlvrd = new String(ByteUtils.rtrimBytes(tmp));
        offset += 3;
        tmp = new byte[10];
        System.arraycopy(bytes, offset += " submit date:".length(), tmp, 0, 10);
        this.subTime = new String(ByteUtils.rtrimBytes(tmp));
        offset += 10;
        tmp = new byte[10];
        System.arraycopy(bytes, offset += " done date:".length(), tmp, 0, 10);
        this.doneTime = new String(ByteUtils.rtrimBytes(tmp));
        offset += 10;
        tmp = new byte[7];
        System.arraycopy(bytes, offset += " stat:".length(), tmp, 0, 7);
        this.stat = new String(ByteUtils.rtrimBytes(tmp));
        offset += 7;
        tmp = new byte[3];
        System.arraycopy(bytes, offset += " err:".length(), tmp, 0, 3);
        this.err = new String(ByteUtils.rtrimBytes(tmp));
        offset += 3;
        tmp = new byte[20];
        System.arraycopy(bytes, offset += " text:".length(), tmp, 0, 20);
        this.txt = new String(ByteUtils.rtrimBytes(tmp));
        offset += 20;
        return true;
    }

    public byte[] toBytes() throws Exception {
        int offset = 0;
        byte[] bytes = new byte[LENGTH];
        System.arraycopy("id:".getBytes(), 0, bytes, offset, "id:".length());
        System.arraycopy(this.msgId, 0, bytes, offset += "id:".length(), 10);
        System.arraycopy(" sub:".getBytes(), 0, bytes, offset += 10, " sub:".length());
        ByteUtils.rfillBytes(this.sub.getBytes(), 3, bytes, offset += " sub:".length());
        System.arraycopy(" dlvrd:".getBytes(), 0, bytes, offset += 3, " dlvrd:".length());
        ByteUtils.rfillBytes(this.dlvrd.getBytes(), 3, bytes, offset += " dlvrd:".length());
        System.arraycopy(" submit date:".getBytes(), 0, bytes, offset += 3, " submit date:".length());
        ByteUtils.rfillBytes(this.subTime.getBytes(), 10, bytes, offset += " submit date:".length());
        System.arraycopy(" done date:".getBytes(), 0, bytes, offset += 10, " done date:".length());
        ByteUtils.rfillBytes(this.doneTime.getBytes(), 10, bytes, offset += " done date:".length());
        System.arraycopy(" stat:".getBytes(), 0, bytes, offset += 10, " stat:".length());
        ByteUtils.rfillBytes(this.stat.getBytes(), 7, bytes, offset += " stat:".length());
        System.arraycopy(" err:".getBytes(), 0, bytes, offset += 7, " err:".length());
        ByteUtils.rfillBytes(this.err.getBytes(), 3, bytes, offset += " err:".length());
        System.arraycopy(" text:".getBytes(), 0, bytes, offset += 3, " text:".length());
        ByteUtils.rfillBytes(this.txt.getBytes(), 20, bytes, offset += " text:".length());
        offset += 20;
        return bytes;
    }

    public String getDlvrd() {
        return this.dlvrd;
    }

    public void setDlvrd(String dlvrd) {
        this.dlvrd = dlvrd;
    }

    public String getDoneTime() {
        return this.doneTime;
    }

    public void setDoneTime(String doneTime) {
        this.doneTime = doneTime;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public byte[] getMsgId() {
        return this.msgId;
    }

    public void setMsgId(byte[] msgId) {
        this.msgId = msgId;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getSubTime() {
        return this.subTime;
    }

    public void setSubTime(String subTime) {
        this.subTime = subTime;
    }

    public String getTxt() {
        return this.txt;
    }

    public void setTxt(String txt) {
        this.txt = txt;
    }

    public String msgIdString() {
        return ByteUtils.byteArrayToHexString(this.msgId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{msgId=").append(this.msgIdString()).append(",").append("sub=").append(this.sub).append(",").append("dlvrd=").append(this.dlvrd).append(",").append("subTime=").append(this.subTime).append(",").append("doneTime=").append(this.doneTime).append(",").append("stat=").append(this.stat).append(",").append("err=").append(this.err).append(",").append("text=").append(this.txt).append("}");
        return buffer.toString();
    }
}

