/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPReportData;
import cn.chenzw.sms.core.protocol.smgp.tlv.TLVByte;
import cn.chenzw.sms.core.protocol.smgp.tlv.TLVString;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.smgp.util.MsgUtils;

public class SMGPDeliverMessage
extends SMGPBaseMessage {
    private byte[] msgId = new byte[10];
    private byte isReport;
    private byte msgFmt;
    private String recvTime;
    private String srcTermId;
    private String destTermId;
    private int msgLength;
    private byte[] bMsgContent;
    private String msgContent;
    private String reserve = "";
    private TLVByte tpPid = new TLVByte(1);
    private TLVByte tpUdhi = new TLVByte(2);
    private TLVString linkId = new TLVString(3);
    private TLVByte srcTermType = new TLVByte(13);
    private TLVString srcTermPseudo = new TLVString(14);
    private TLVByte submitMsgType = new TLVByte(11);
    private TLVByte spDealResult = new TLVByte(12);

    public SMGPDeliverMessage() {
        this.commandId = 3;
        this.registerOptional(this.tpPid);
        this.registerOptional(this.tpUdhi);
        this.registerOptional(this.linkId);
        this.registerOptional(this.srcTermType);
        this.registerOptional(this.srcTermPseudo);
        this.registerOptional(this.submitMsgType);
        this.registerOptional(this.spDealResult);
    }

    public void setTpPid(byte value) {
        this.tpPid.setValue(value);
    }

    public byte getTpPid() {
        return this.tpPid.getValue();
    }

    public void setTpUdhi(byte value) {
        this.tpUdhi.setValue(value);
    }

    public byte getTpUdhi() {
        return this.tpUdhi.getValue();
    }

    public void setLinkId(String value) {
        this.linkId.setValue(value);
    }

    public String getLinkId() {
        return this.linkId.getValue();
    }

    public void setSrcTermType(byte value) {
        this.srcTermType.setValue(value);
    }

    public byte getSrcTermType() {
        return this.srcTermType.getValue();
    }

    public void setSrcTermPseudo(String value) {
        this.srcTermPseudo.setValue(value);
    }

    public String getSrcTermPseudo() {
        return this.srcTermPseudo.getValue();
    }

    public void setSubmitMsgType(byte value) {
        this.submitMsgType.setValue(value);
    }

    public byte getSubmitMsgType() {
        return this.submitMsgType.getValue();
    }

    public void setSpDealResult(byte value) {
        this.spDealResult.setValue(value);
    }

    public byte getSpDealResult() {
        return this.spDealResult.getValue();
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int offset = 0;
        byte[] tmp = null;
        this.msgId = new byte[10];
        System.arraycopy(bodyBytes, offset, this.msgId, 0, 10);
        this.isReport = bodyBytes[offset += 10];
        this.msgFmt = bodyBytes[++offset];
        tmp = new byte[14];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 14);
        this.recvTime = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 14, tmp, 0, 21);
        this.srcTermId = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 21, tmp, 0, 21);
        this.destTermId = new String(ByteUtils.rtrimBytes(tmp));
        int b = bodyBytes[offset += 21];
        ++offset;
        int n = this.msgLength = b >= 0 ? b : 256 + b;
        if (this.msgLength > 0) {
            tmp = new byte[this.msgLength];
            System.arraycopy(bodyBytes, offset, tmp, 0, this.msgLength);
            offset += this.msgLength;
            this.bMsgContent = tmp;
            this.msgContent = MsgUtils.formatMsg(this.bMsgContent, this.msgFmt);
        }
        tmp = new byte[8];
        System.arraycopy(bodyBytes, offset, tmp, 0, 8);
        this.reserve = new String(ByteUtils.rtrimBytes(tmp));
        return offset += 8;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int len = 69 + this.msgLength + 8;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        System.arraycopy(this.msgId, 0, bodyBytes, offset, 10);
        bodyBytes[offset += 10] = this.isReport;
        bodyBytes[++offset] = this.msgFmt;
        ByteUtils.rfillBytes(this.recvTime.getBytes(), 14, bodyBytes, ++offset);
        ByteUtils.rfillBytes(this.srcTermId.getBytes(), 21, bodyBytes, offset += 14);
        ByteUtils.rfillBytes(this.destTermId.getBytes(), 21, bodyBytes, offset += 21);
        bodyBytes[offset += 21] = (byte)this.msgLength;
        ++offset;
        if (this.bMsgContent != null) {
            ByteUtils.rfillBytes(this.bMsgContent, this.msgLength, bodyBytes, offset);
        }
        ByteUtils.rfillBytes(this.reserve.getBytes(), 8, bodyBytes, offset += this.msgLength);
        offset += 8;
        return bodyBytes;
    }

    public byte[] getMsgId() {
        return this.msgId;
    }

    public void setMsgId(byte[] msgId) {
        this.msgId = msgId;
    }

    public byte getIsReport() {
        return this.isReport;
    }

    public void setIsReport(byte isReport) {
        this.isReport = isReport;
    }

    public byte getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(byte msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getRecvTime() {
        return this.recvTime;
    }

    public void setRecvTime(String recvTime) {
        this.recvTime = recvTime;
    }

    public String getSrcTermId() {
        return this.srcTermId;
    }

    public void setSrcTermId(String srcTermId) {
        this.srcTermId = srcTermId;
    }

    public String getDestTermId() {
        return this.destTermId;
    }

    public void setDestTermId(String destTermId) {
        this.destTermId = destTermId;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int msgLength) {
        this.msgLength = msgLength;
    }

    public byte[] getBMsgContent() {
        return this.bMsgContent;
    }

    public void setBMsgContent(byte[] msgContent) {
        this.bMsgContent = msgContent;
        this.msgLength = this.bMsgContent == null ? 0 : this.bMsgContent.length;
    }

    public String getMsgContent() {
        if (this.bMsgContent == null) {
            return null;
        }
        if (this.isReport == 1) {
            return MsgUtils.getReportData(this.bMsgContent).toString();
        }
        if (this.msgContent != null) {
            return this.msgContent;
        }
        String msg = null;
        try {
            msg = MsgUtils.formatMsg(this.bMsgContent, this.msgFmt);
            msg = msg.trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    public void setMsgContent(String msgContent) {
        if (msgContent != null) {
            this.bMsgContent = msgContent.getBytes();
            this.msgContent = msgContent;
            this.msgLength = msgContent.getBytes().length == msgContent.length() ? msgContent.length() : msgContent.length() * 2;
            this.isReport = 0;
        } else {
            this.msgLength = 0;
            this.bMsgContent = null;
            this.msgContent = null;
        }
    }

    public SMGPReportData getReport() {
        if (this.isReport == 0 || this.bMsgContent == null) {
            return null;
        }
        return MsgUtils.getReportData(this.bMsgContent);
    }

    public void setReport(SMGPReportData report) {
        if (report == null) {
            return;
        }
        try {
            this.bMsgContent = report.toBytes();
            this.msgContent = report.toString();
            this.msgLength = SMGPReportData.LENGTH;
            this.isReport = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public String msgIdString() {
        return ByteUtils.byteArrayToHexString(this.msgId);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPDeliverMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgId=").append(this.msgIdString()).append(",");
        buffer.append("isReport=").append(this.isReport).append(",");
        buffer.append("msgFmt=").append(this.msgFmt).append(",");
        buffer.append("recvTime=").append(this.recvTime).append(",");
        buffer.append("srcTermId=").append(this.srcTermId).append(",");
        buffer.append("destTermId=").append(this.destTermId).append(",");
        buffer.append("msgLength=").append(this.msgLength).append(",");
        buffer.append("msgContent=").append(this.getMsgContent()).append("]");
        return buffer.toString();
    }
}

