/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.protocol.smgp.tlv.TLV;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;
import java.util.Vector;

public class SMGPBaseMessage
implements Message {
    public static final int SZ_HEADER = 12;
    protected int commandLength = 0;
    protected int commandId = 0;
    protected int sequenceNumber = 0;
    protected Object extId;
    protected Vector optionalParameters = new Vector(10, 2);

    public boolean fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return false;
        }
        if (bytes.length < 12) {
            return false;
        }
        int offset = 0;
        this.commandLength = ByteUtils.byte2int(bytes, offset);
        this.commandId = ByteUtils.byte2int(bytes, offset += 4);
        this.sequenceNumber = ByteUtils.byte2int(bytes, offset += 4);
        byte[] bodyBytes = new byte[this.commandLength - 12];
        System.arraycopy(bytes, offset += 4, bodyBytes, 0, bodyBytes.length);
        int bodyLength = this.setBody(bodyBytes);
        if (bodyLength < bodyBytes.length) {
            byte[] optBytes = new byte[bodyBytes.length - bodyLength];
            System.arraycopy(bodyBytes, bodyLength, optBytes, 0, optBytes.length);
            this.setOptionalBody(optBytes);
        }
        return true;
    }

    public byte[] toBytes() throws Exception {
        byte[] bodyBytes = this.getBody();
        byte[] optBytes = this.getOptionalBody();
        this.commandLength = 12 + bodyBytes.length + optBytes.length;
        int offset = 0;
        byte[] bytes = new byte[this.commandLength];
        ByteUtils.int2byte(this.commandLength, bytes, offset);
        ByteUtils.int2byte(this.commandId, bytes, offset += 4);
        ByteUtils.int2byte(this.sequenceNumber, bytes, offset += 4);
        System.arraycopy(bodyBytes, 0, bytes, offset += 4, bodyBytes.length);
        System.arraycopy(optBytes, 0, bytes, offset += bodyBytes.length, optBytes.length);
        offset += optBytes.length;
        return bytes;
    }

    protected int setBody(byte[] bodyBytes) throws Exception {
        return 0;
    }

    protected byte[] getBody() throws Exception {
        return new byte[0];
    }

    private void setOptionalBody(byte[] buffer) throws Exception {
        short length;
        TLV tlv = null;
        for (int offset = 0; offset < buffer.length; offset += length) {
            short tag = ByteUtils.byte2short(buffer, offset);
            offset += 2;
            tlv = this.findOptional(tag);
            if (tlv == null) break;
            length = ByteUtils.byte2short(buffer, offset);
            byte[] valueBytes = new byte[length];
            System.arraycopy(buffer, offset += 2, valueBytes, 0, length);
            tlv.setValueData(valueBytes);
        }
    }

    private byte[] getOptionalBody() throws Exception {
        int size = this.optionalParameters.size();
        TLV tlv = null;
        int len = 0;
        for (int i = 0; i < size; ++i) {
            tlv = (TLV)this.optionalParameters.get(i);
            if (!tlv.hasValue()) continue;
            len += 4 + tlv.getLength();
        }
        byte[] bytes = new byte[len];
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            tlv = (TLV)this.optionalParameters.get(i);
            offset = tlv.toBytes(bytes, offset);
        }
        if (offset == 0) {
            return new byte[0];
        }
        byte[] result = new byte[offset];
        System.arraycopy(bytes, 0, result, 0, offset);
        return result;
    }

    protected void registerOptional(TLV tlv) {
        if (tlv != null) {
            this.optionalParameters.add(tlv);
        }
    }

    private TLV findOptional(short tag) {
        int size = this.optionalParameters.size();
        TLV tlv = null;
        for (int i = 0; i < size; ++i) {
            tlv = (TLV)this.optionalParameters.get(i);
            if (tlv == null || tlv.getTag() != tag) continue;
            return tlv;
        }
        return null;
    }

    protected String plus86(String mobile) {
        return this.minus86(mobile);
    }

    protected String minus86(String mobile) {
        if (mobile == null || mobile.trim().length() == 0) {
            return "";
        }
        if (mobile.startsWith("86")) {
            return mobile.substring(2);
        }
        if (mobile.startsWith("+86")) {
            return mobile.substring(3);
        }
        return mobile;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public int getCommandLength() {
        return this.commandLength;
    }

    public void setCommandLength(int commandLength) {
        this.commandLength = commandLength;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Object getExtId() {
        return this.extId;
    }

    public void setExtId(Object extId) {
        this.extId = extId;
    }

    public String sequenceString() {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        byte[] seqBytes = new byte[8];
        System.arraycopy(ByteUtils.int2byte(this.sequenceNumber), offset, seqBytes, 4, 4);
        buffer.append(ByteUtils.byte2long(seqBytes));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPBaseMessage:[sequenceNumber=").append(this.sequenceString()).append(",").append("commandId=").append(this.commandId).append(",").append("extId=").append(this.extId).append("]");
        return buffer.toString();
    }
}

