/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp;

import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.Reader;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPConstants;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMGPReader
implements Reader {
    protected DataInputStream in;

    public SMGPReader(InputStream is) {
        this.in = new DataInputStream(is);
    }

    @Override
    public Message read() throws IOException {
        byte[] header = new byte[12];
        byte[] cmdBytes = null;
        this.readBytes(header, 0, 12);
        int cmdLen = ByteUtils.byte2int(header, 0);
        if (cmdLen > 8096 || cmdLen < 12) {
            throw new IOException("read stream error,cmdLen=" + cmdLen + ",close connection");
        }
        cmdBytes = new byte[cmdLen];
        System.arraycopy(header, 0, cmdBytes, 0, 12);
        this.readBytes(cmdBytes, 12, cmdLen - 12);
        try {
            SMGPBaseMessage baseMsg = SMGPConstants.fromBytes(cmdBytes);
            return baseMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("build SMGPBaseMessage error:" + e.getMessage());
        }
    }

    private void readBytes(byte[] bytes, int offset, int len) throws IOException {
        this.in.readFully(bytes, offset, len);
    }
}

