/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp;

import cn.chenzw.sms.core.Connection;
import cn.chenzw.sms.core.Reader;
import cn.chenzw.sms.core.Session;
import cn.chenzw.sms.core.Writer;
import cn.chenzw.sms.core.protocol.smgp.SMGPReader;
import cn.chenzw.sms.core.protocol.smgp.SMGPSession;
import cn.chenzw.sms.core.protocol.smgp.SMGPWriter;
import java.io.InputStream;
import java.io.OutputStream;

public class SMGPConnection
extends Connection {
    public static final byte MT = 0;
    public static final byte MO = 1;
    public static final byte MT_MO = 2;
    private String clientId;
    private String password;
    private byte loginMode;
    private byte version;

    public SMGPConnection() {
        this.setLoginMode((byte)2);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public byte getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(byte loginMode) {
        this.loginMode = loginMode;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    protected Session createSession() {
        return new SMGPSession(this, false);
    }

    @Override
    protected Writer createWriter(OutputStream output) {
        return new SMGPWriter(output);
    }

    @Override
    protected Reader createReader(InputStream input) {
        return new SMGPReader(input);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("smgp:[clientId=").append(this.clientId).append(",").append("host=").append(this.getHost()).append(",").append("port=").append(this.getPort()).append(",").append("password=").append(this.password).append(",").append("loginMode=").append(this.loginMode).append("]");
        return buffer.toString();
    }
}

