/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.util;

import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.io.UnsupportedEncodingException;

public class MsgUtils {
    public static byte[] getMsgBytes(String msgText, int msgFmt) {
        byte[] binCnt = null;
        try {
            switch (msgFmt) {
                case 0: {
                    binCnt = msgText.getBytes("US-ASCII");
                    break;
                }
                case 3: {
                    binCnt = msgText.getBytes("US-ASCII");
                    break;
                }
                case 4: {
                    binCnt = msgText.getBytes("US-ASCII");
                    break;
                }
                case 8: {
                    binCnt = msgText.getBytes("ISO-10646-UCS-2");
                    break;
                }
                case 15: {
                    binCnt = msgText.getBytes("GBK");
                    break;
                }
                default: {
                    binCnt = msgText.getBytes();
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            binCnt = msgText.getBytes();
        }
        return binCnt;
    }

    public static int calMsgLength(byte[] msgContent, int msgFmt, int maxMsgLength0, int maxMsgLength1) {
        int msgLength = 0;
        if (msgContent == null) {
            msgLength = 0;
        } else {
            if (msgFmt == 0) {
                if (msgContent.length > maxMsgLength0) {
                    msgContent = new byte[maxMsgLength0];
                    ByteUtils.bytesCopy(msgContent, msgContent, 0, maxMsgLength0 - 1, 0);
                }
            } else if (msgContent.length > maxMsgLength1) {
                msgContent = new byte[maxMsgLength1];
                ByteUtils.bytesCopy(msgContent, msgContent, 0, maxMsgLength1 - 1, 0);
            }
            msgLength = msgContent.length;
        }
        return msgLength;
    }

    public String getMsgHexText(byte[] msgContent, byte msgFmt) {
        String msgText = null;
        if (msgContent == null) {
            return null;
        }
        switch (msgFmt) {
            case 0: {
                msgText = ByteUtils.byteToHexString(msgContent, "US-ASCII");
                break;
            }
            case 3: {
                msgText = ByteUtils.byteToHexString(msgContent, "US-ASCII");
                break;
            }
            case 4: {
                msgText = ByteUtils.byteToHexString(msgContent, "BIN");
                break;
            }
            case 8: {
                msgText = ByteUtils.byteToHexString(msgContent, "ISO-10646-UCS-2");
                break;
            }
            case 15: {
                msgText = ByteUtils.byteToHexString(msgContent, "GBK");
                break;
            }
            default: {
                msgText = ByteUtils.byteToHexString(msgContent, null);
            }
        }
        return msgText;
    }

    public String getMsgText(byte[] msgContent, byte msgFmt) {
        String msgText = null;
        if (msgContent == null) {
            return null;
        }
        try {
            switch (msgFmt) {
                case 0: {
                    msgText = new String(msgContent, "US-ASCII");
                    break;
                }
                case 3: {
                    msgText = new String(msgContent, "US-ASCII");
                    break;
                }
                case 4: {
                    msgText = ByteUtils.toPrintableString(msgContent);
                    break;
                }
                case 8: {
                    msgText = new String(msgContent, "ISO-10646-UCS-2");
                    break;
                }
                case 15: {
                    msgText = new String(msgContent, "GBK");
                    break;
                }
                default: {
                    msgText = ByteUtils.toPrintableString(msgContent);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            msgText = ByteUtils.toPrintableString(msgContent);
        }
        return msgText;
    }
}

