/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.util;

import java.io.UnsupportedEncodingException;

public class ByteUtils {
    public static byte intToByte(int i) {
        return (byte)i;
    }

    public static byte[] intToBytes(int i) {
        byte[] abyte0 = new byte[2];
        abyte0[1] = (byte)(0xFF & i);
        abyte0[0] = (byte)((0xFF00 & i) >> 8);
        return abyte0;
    }

    public static void intToBytes(int i, byte[] abyte0) {
        abyte0[1] = (byte)(0xFF & i);
        abyte0[0] = (byte)((0xFF00 & i) >> 8);
    }

    public static byte[] intToBytes4(int i) {
        byte[] abyte0 = new byte[4];
        abyte0[3] = (byte)(0xFF & i);
        abyte0[2] = (byte)((0xFF00 & i) >> 8);
        abyte0[1] = (byte)((0xFF0000 & i) >> 16);
        abyte0[0] = (byte)((0xFF000000 & i) >> 24);
        return abyte0;
    }

    public static void intToBytes4(int i, byte[] abyte0) {
        abyte0[3] = (byte)(0xFF & i);
        abyte0[2] = (byte)((0xFF00 & i) >> 8);
        abyte0[1] = (byte)((0xFF0000 & i) >> 16);
        abyte0[0] = (byte)((0xFFFFFFFFFF000000L & (long)i) >> 24);
    }

    public static byte[] longToBytes8(long i) {
        byte[] abyte0 = new byte[8];
        abyte0[7] = (byte)(0xFFL & i);
        abyte0[6] = (byte)((0xFF00L & i) >> 8);
        abyte0[5] = (byte)((0xFF0000L & i) >> 16);
        abyte0[4] = (byte)((0xFF000000L & i) >> 24);
        abyte0[3] = (byte)((0xFF00000000L & i) >> 32);
        abyte0[2] = (byte)((0xFF0000000000L & i) >> 40);
        abyte0[1] = (byte)((0xFF000000000000L & i) >> 48);
        abyte0[0] = (byte)((0xFF00000000000000L & i) >> 56);
        return abyte0;
    }

    public static int byteToInt(byte byte0) {
        return byte0;
    }

    public static int BytesToInt(byte[] abyte0) {
        return ((0xFF & abyte0[0]) << 8) + abyte0[1];
    }

    public static int Bytes4ToInt(byte[] abyte0) {
        return (0xFF & abyte0[0]) << 24 | (0xFF & abyte0[1]) << 16 | (0xFF & abyte0[2]) << 8 | 0xFF & abyte0[3];
    }

    public static long Bytes8ToLong(byte[] abyte0) {
        long ret = 0L;
        ret = (0xFFL & (long)abyte0[0]) << 56 | (0xFFL & (long)abyte0[1]) << 48 | (0xFFL & (long)abyte0[2]) << 40 | (0xFFL & (long)abyte0[3]) << 32 | (0xFFL & (long)abyte0[4]) << 24 | (0xFFL & (long)abyte0[5]) << 16 | (0xFFL & (long)abyte0[6]) << 8 | 0xFFL & (long)abyte0[7];
        return ret;
    }

    public static void bytesCopy(byte[] srcAbyte, byte[] destAbyte, int srcFrom, int srcTo, int destFrom) {
        if (srcAbyte == null || destAbyte == null) {
            return;
        }
        int i1 = 0;
        for (int l = srcFrom; l <= srcTo && destFrom + i1 < destAbyte.length && l < srcAbyte.length; ++l) {
            destAbyte[destFrom + i1] = srcAbyte[l];
            ++i1;
        }
    }

    public static String byteToHexString(byte[] b, String charset) {
        String str = null;
        if (b == null) {
            return null;
        }
        if (charset != null) {
            try {
                str = new String(b, charset);
            }
            catch (UnsupportedEncodingException e1) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < b.length; ++i) {
                    char chHi = Character.forDigit((b[i] & 0xF0) >> 4, 16);
                    char chLow = Character.forDigit(b[i] & 0xF, 16);
                    sb.append(chHi);
                    sb.append(chLow);
                    sb.append(' ');
                }
                str = sb.toString().toUpperCase();
            }
        } else {
            str = new String(b);
        }
        return str;
    }

    public static String toPrintableString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        byte[] t = new byte[1];
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 32 && b[i] <= 126) {
                t[0] = b[i];
                sb.append(new String(t));
                continue;
            }
            sb.append(".");
        }
        return sb.toString();
    }
}

