/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.cmpp.util.MsgUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CMPPSubmitMessage
extends CMPPBaseMessage {
    private final int maxMsgLength0 = 160;
    private final int maxMsgLength1 = 140;
    private long msgId = 0L;
    private int pkTotal = 1;
    private int pkNumber = 1;
    private int registeredDelivery = 0;
    private int msgLevel = 0;
    private String serviceId = null;
    private int feeUserType = 0;
    private String feeTerminalId = null;
    private int tpPid = 0;
    private int tpUdhi = 0;
    private int msgFmt = 0;
    private String msgSrc = null;
    private String feeType = null;
    private String feeCode = null;
    private String validTime = null;
    private String atTime = null;
    private String srcId = null;
    private int destUsrTl = 0;
    private List destTerminalId = new ArrayList();
    private int msgLength = 0;
    private byte[] msgContent = null;
    private String reserve = null;

    public CMPPSubmitMessage() {
        super(4, 126);
    }

    public String getAtTime() {
        return this.atTime;
    }

    public void setAtTime(String atTime) {
        this.atTime = atTime;
    }

    public List getDestTerminalId() {
        return this.destTerminalId;
    }

    public void addDestTerminalId(String destTerminalId) {
        if (destTerminalId == null) {
            return;
        }
        this.destTerminalId.add(destTerminalId);
        this.destUsrTl = this.destTerminalId.size();
    }

    public void removeDestTerminalId(String destTerminalId) {
        if (destTerminalId == null) {
            return;
        }
        this.destTerminalId.remove(destTerminalId);
        this.destUsrTl = this.destTerminalId.size();
    }

    public int getDestUsrTl() {
        return this.destUsrTl;
    }

    public String getFeeCode() {
        return this.feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getFeeTerminalId() {
        return this.feeTerminalId;
    }

    public void setFeeTerminalId(String feeTerminalId) {
        this.feeTerminalId = feeTerminalId;
    }

    public int getFeeUserType() {
        return this.feeUserType;
    }

    public void setFeeUserType(int feeUserType) {
        this.feeUserType = feeUserType;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public byte[] getMsgContent() {
        return this.msgContent;
    }

    public void setMsgText(String msgText, int msgFmt) {
        byte[] msgBytes = MsgUtils.getMsgBytes(msgText, msgFmt);
        this.msgFmt = msgFmt;
        this.msgContent = msgBytes;
        this.msgLength = MsgUtils.calMsgLength(this.msgContent, msgFmt, 160, 140);
    }

    public int getMsgFmt() {
        return this.msgFmt;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public int getMsgLevel() {
        return this.msgLevel;
    }

    public void setMsgLevel(int msgLevel) {
        this.msgLevel = msgLevel;
    }

    public String getMsgSrc() {
        return this.msgSrc;
    }

    public void setMsgSrc(String msgSrc) {
        this.msgSrc = msgSrc;
    }

    public int getPkNumber() {
        return this.pkNumber;
    }

    public void setPkNumber(int pkNumber) {
        this.pkNumber = pkNumber;
    }

    public int getPkTotal() {
        return this.pkTotal;
    }

    public void setPkTotal(int pkTotal) {
        this.pkTotal = pkTotal;
    }

    public int getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(int registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public int getTpPid() {
        return this.tpPid;
    }

    public void setTpPid(int pid) {
        this.tpPid = pid;
    }

    public int getTpUdhi() {
        return this.tpUdhi;
    }

    public void setTpUdhi(int udhi) {
        this.tpUdhi = udhi;
    }

    public String getValidTime() {
        return this.validTime;
    }

    public void setValidTime(String validTime) {
        this.validTime = validTime;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    private String byteToHexString(byte[] b, String charset) {
        String str = null;
        if (b == null) {
            return null;
        }
        if (charset != null) {
            try {
                str = new String(b, charset);
            }
            catch (UnsupportedEncodingException e1) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < b.length; ++i) {
                    char chHi = Character.forDigit((b[i] & 0xF0) >> 4, 16);
                    char chLow = Character.forDigit(b[i] & 0xF, 16);
                    sb.append(chHi);
                    sb.append(chLow);
                    sb.append(' ');
                }
                str = sb.toString().toUpperCase();
            }
        } else {
            str = new String(b);
        }
        return str;
    }

    private String toPrintableString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        byte[] t = new byte[1];
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 32 && b[i] <= 126) {
                t[0] = b[i];
                sb.append(new String(t));
                continue;
            }
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        byte[] abyte0 = new byte[21];
        int off = 0;
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 7, 0);
        this.msgId = ByteUtils.Bytes8ToLong(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 8, off, 0);
        this.pkTotal = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.pkNumber = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.registeredDelivery = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.msgLevel = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 9, 0);
        this.serviceId = new String(abyte0, 0, 10);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 10, off, 0);
        this.feeUserType = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 20, 0);
        this.feeTerminalId = new String(abyte0, 0, 21);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 21, off, 0);
        this.tpPid = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.tpUdhi = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.msgFmt = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 5, 0);
        this.msgSrc = new String(abyte0, 0, 6);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 6, off + 1, 0);
        this.feeType = new String(abyte0, 0, 2);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 2, off + 5, 0);
        this.feeCode = new String(abyte0, 0, 6);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 6, off + 16, 0);
        this.validTime = new String(abyte0, 0, 17);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 17, off + 16, 0);
        this.atTime = new String(abyte0, 0, 17);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 17, off + 20, 0);
        this.srcId = new String(abyte0, 0, 21);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 21, off, 0);
        this.destUsrTl = ByteUtils.byteToInt(abyte0[0]);
        ++off;
        for (int i = 0; i < this.destUsrTl; ++i) {
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 20, 0);
            this.destTerminalId.add(new String(abyte0, 0, 21));
            off += 21;
        }
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off, 0);
        this.msgLength = ByteUtils.byteToInt(abyte0[0]);
        this.msgContent = new byte[this.msgLength];
        ByteUtils.bytesCopy(bodyBytes, this.msgContent, ++off, off + this.msgLength - 1, 0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += this.msgLength, off + 7, 0);
        this.reserve = new String(abyte0, 0, 8);
        off += 8;
    }

    protected int makeBody() {
        int bodyLength = this.getCommandLength() + 21 * this.destUsrTl + this.msgLength;
        byte[] bodyBytes = new byte[bodyLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.serviceId == null) {
            this.serviceId = "";
        }
        if (this.feeTerminalId == null) {
            this.feeTerminalId = "";
        }
        if (this.msgSrc == null) {
            this.msgSrc = "";
        }
        if (this.feeType == null) {
            this.feeType = "";
        }
        if (this.feeCode == null) {
            this.feeCode = "";
        }
        if (this.validTime == null) {
            this.validTime = "";
        }
        if (this.atTime == null) {
            this.atTime = "";
        }
        if (this.srcId == null) {
            this.srcId = "";
        }
        if (this.reserve == null) {
            this.reserve = "";
        }
        if (this.msgContent == null) {
            this.msgContent = new byte[0];
        }
        int off = 0;
        ByteUtils.bytesCopy(ByteUtils.longToBytes8(this.msgId), bodyBytes, 0, 7, off);
        bodyBytes[off += 8] = ByteUtils.intToByte(this.pkTotal);
        bodyBytes[++off] = ByteUtils.intToByte(this.pkNumber);
        bodyBytes[++off] = ByteUtils.intToByte(this.registeredDelivery);
        bodyBytes[++off] = ByteUtils.intToByte(this.msgLevel);
        ByteUtils.bytesCopy(this.serviceId.getBytes(), bodyBytes, 0, 9, ++off);
        bodyBytes[off += 10] = ByteUtils.intToByte(this.feeUserType);
        ByteUtils.bytesCopy(this.feeTerminalId.getBytes(), bodyBytes, 0, 20, ++off);
        bodyBytes[off += 21] = ByteUtils.intToByte(this.tpPid);
        bodyBytes[++off] = ByteUtils.intToByte(this.tpUdhi);
        bodyBytes[++off] = ByteUtils.intToByte(this.msgFmt);
        ByteUtils.bytesCopy(this.msgSrc.getBytes(), bodyBytes, 0, 5, ++off);
        ByteUtils.bytesCopy(this.feeType.getBytes(), bodyBytes, 0, 1, off += 6);
        ByteUtils.bytesCopy(this.feeCode.getBytes(), bodyBytes, 0, 5, off += 2);
        ByteUtils.bytesCopy(this.validTime.getBytes(), bodyBytes, 0, 16, off += 6);
        ByteUtils.bytesCopy(this.atTime.getBytes(), bodyBytes, 0, 16, off += 17);
        ByteUtils.bytesCopy(this.srcId.getBytes(), bodyBytes, 0, 20, off += 17);
        bodyBytes[off += 21] = ByteUtils.intToByte(this.destUsrTl);
        ++off;
        for (int i = 0; i < this.destTerminalId.size(); ++i) {
            String id = (String)this.destTerminalId.get(i);
            ByteUtils.bytesCopy(id.getBytes(), bodyBytes, 0, 20, off);
            off += 21;
        }
        bodyBytes[off] = ByteUtils.intToByte(this.msgLength);
        ByteUtils.bytesCopy(this.msgContent, bodyBytes, 0, this.msgLength - 1, ++off);
        ByteUtils.bytesCopy(this.reserve.getBytes(), bodyBytes, 0, 7, off += this.msgContent.length);
        off += 8;
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPSubmitMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("extId=" + this.extId + ",");
        sb.append("msgId=" + this.msgId + ",");
        sb.append("pkTotal=" + this.pkTotal + ",");
        sb.append("pkNumber=" + this.pkNumber + ",");
        sb.append("registeredDelivery=" + this.registeredDelivery + ",");
        sb.append("msgLevel=" + this.msgLevel + ",");
        sb.append("serviceId=" + this.serviceId + ",");
        sb.append("feeUserType=" + this.feeUserType + ",");
        sb.append("feeTerminalId=" + this.feeTerminalId + ",");
        sb.append("tpPid=" + this.tpPid + ",");
        sb.append("tpUdhi=" + this.tpUdhi + ",");
        sb.append("msgFmt=" + this.msgFmt + ",");
        sb.append("msgSrc=" + this.msgSrc + ",");
        sb.append("feeType=" + this.feeType + ",");
        sb.append("feeCode=" + this.feeCode + ",");
        sb.append("validTime=" + this.validTime + ",");
        sb.append("atTime=" + this.atTime + ",");
        sb.append("srcId=" + this.srcId + ",");
        sb.append("destUsrTl=" + this.destUsrTl + ",");
        sb.append("destTerminalId=" + this.destTerminalId + ",");
        sb.append("msgLength=" + this.msgLength + ",");
        sb.append("msgContent=" + this.msgContent + ",");
        sb.append("reserve=" + this.reserve + "]");
        return sb.toString();
    }
}

