/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPActiveTestMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPActiveTestRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPCancelMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPCancelRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPConnectMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPConnectRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPDeliverMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPDeliverRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPQueryMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPQueryRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPSubmitMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPSubmitRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPTerminateMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPTerminateRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;

public class CMPPConstants {
    public static final int CMPP_VERSION = 32;
    public static final int CMPP_CONNECT = 1;
    public static final int CMPP_CONNECT_RESP = -2147483647;
    public static final int CMPP_TERMINATE = 2;
    public static final int CMPP_TERMINATE_RESP = -2147483646;
    public static final int CMPP_SUBMIT = 4;
    public static final int CMPP_SUBMIT_RESP = -2147483644;
    public static final int CMPP_DELIVER = 5;
    public static final int CMPP_DELIVER_RESP = -2147483643;
    public static final int CMPP_QUERY = 6;
    public static final int CMPP_QUERY_RESP = -2147483642;
    public static final int CMPP_CANCEL = 7;
    public static final int CMPP_CANCEL_RESP = -2147483641;
    public static final int CMPP_ACTIVE_TEST = 8;
    public static final int CMPP_ACTIVE_TEST_RESP = -2147483640;

    public static CMPPBaseMessage fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        if (bytes.length < 12) {
            return null;
        }
        byte[] headBytes = new byte[4];
        int offset = 0;
        ByteUtils.bytesCopy(bytes, headBytes, offset, offset + 3, 0);
        ByteUtils.bytesCopy(bytes, headBytes, offset += 4, offset + 3, 0);
        int commandId = ByteUtils.Bytes4ToInt(headBytes);
        ByteUtils.bytesCopy(bytes, headBytes, offset += 4, offset + 3, 0);
        CMPPBaseMessage baseMsg = null;
        switch (commandId) {
            case 1: {
                baseMsg = new CMPPConnectMessage();
                break;
            }
            case -2147483647: {
                baseMsg = new CMPPConnectRespMessage();
                break;
            }
            case 2: {
                baseMsg = new CMPPTerminateMessage();
                break;
            }
            case -2147483646: {
                baseMsg = new CMPPTerminateRespMessage();
                break;
            }
            case 4: {
                baseMsg = new CMPPSubmitMessage();
                break;
            }
            case -2147483644: {
                baseMsg = new CMPPSubmitRespMessage();
                break;
            }
            case 5: {
                baseMsg = new CMPPDeliverMessage();
                break;
            }
            case -2147483643: {
                baseMsg = new CMPPDeliverRespMessage();
                break;
            }
            case 6: {
                baseMsg = new CMPPQueryMessage();
                break;
            }
            case -2147483642: {
                baseMsg = new CMPPQueryRespMessage();
                break;
            }
            case 7: {
                baseMsg = new CMPPCancelMessage();
                break;
            }
            case -2147483641: {
                baseMsg = new CMPPCancelRespMessage();
                break;
            }
            case 8: {
                baseMsg = new CMPPActiveTestMessage();
                break;
            }
            case -2147483640: {
                baseMsg = new CMPPActiveTestRespMessage();
                break;
            }
            default: {
                baseMsg = null;
            }
        }
        baseMsg.fromBytes(bytes);
        return baseMsg;
    }
}

