/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.cmpp.util.Md5Utils;
import java.util.Arrays;

public class CMPPConnectRespMessage
extends CMPPBaseMessage {
    private int status = 0;
    private byte[] authenticatorISMG = null;
    private int version = 32;
    private byte[] authenticatorSource = null;
    private String sharedSecret = null;

    public CMPPConnectRespMessage() {
        super(-2147483647, 18);
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getAuthenticatorISMG() {
        return this.authenticatorISMG;
    }

    public int getVersion() {
        return this.version;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setAuthenticatorSource(byte[] authenticatorSource) {
        this.authenticatorSource = authenticatorSource;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public boolean checkSharedSecret(byte[] authenticatorSource, String localSecret) {
        byte[] localAuthenticator = this.getAuthenticator(this.status, authenticatorSource, localSecret);
        return Arrays.equals(localAuthenticator, this.authenticatorISMG);
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        int off = 0;
        this.status = bodyBytes[off];
        this.authenticatorISMG = new byte[16];
        ByteUtils.bytesCopy(bodyBytes, this.authenticatorISMG, ++off, off + 15, 0);
        this.version = bodyBytes[off += 16];
        ++off;
    }

    @Override
    protected byte[] getBody() {
        int bodyLength = this.getCommandLength();
        byte[] bodyBytes = new byte[bodyLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.authenticatorSource == null) {
            this.authenticatorSource = new byte[0];
        }
        if (this.sharedSecret == null) {
            this.sharedSecret = "";
        }
        this.authenticatorISMG = this.getAuthenticator(this.status, this.authenticatorSource, this.sharedSecret);
        int off = 0;
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.status), bodyBytes, 0, 3, off);
        ByteUtils.bytesCopy(this.authenticatorISMG, bodyBytes, 0, 15, off += 4);
        bodyBytes[off += 16] = ByteUtils.intToByte(this.version);
        ++off;
        return bodyBytes;
    }

    private byte[] getAuthenticator(int status, byte[] authenticatorSource, String secret) {
        if (authenticatorSource == null) {
            authenticatorSource = new byte[]{};
        }
        if (secret == null) {
            secret = "";
        }
        byte[] buffer = new byte[1 + authenticatorSource.length + secret.length()];
        Arrays.fill(buffer, (byte)0);
        int off = 0;
        buffer[off] = ByteUtils.intToByte(status);
        ByteUtils.bytesCopy(authenticatorSource, buffer, 0, authenticatorSource.length - 1, ++off);
        ByteUtils.bytesCopy(secret.getBytes(), buffer, 0, secret.length() - 1, off += authenticatorSource.length);
        off += secret.length();
        return Md5Utils.md5(buffer);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPConnectRespMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("status=" + this.status + ",");
        sb.append("authenticatorISMG=" + this.authenticatorISMG + ",");
        sb.append("version=" + this.version + "]");
        return sb.toString();
    }
}

