/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.cmpp.util.Md5Utils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public final class CMPPConnectMessage
extends CMPPBaseMessage {
    private String sourceAddr = null;
    private byte[] authenticatorSource = null;
    private String sharedSecret = null;
    private int version = 32;
    private int timestamp = 0;

    public CMPPConnectMessage() {
        super(1, 27);
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public byte[] getAuthenticatorSource() {
        return this.authenticatorSource;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int value) {
        this.version = value;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int value) {
        this.timestamp = value;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public boolean checkSharedSecret(String localSecret) {
        byte[] localAuthenticator = this.getAuthenticator(this.sourceAddr, localSecret, this.timestamp);
        return Arrays.equals(localAuthenticator, this.authenticatorSource);
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        int off = 0;
        byte[] abyte0 = new byte[16];
        this.sourceAddr = new String(bodyBytes, off, 6);
        this.authenticatorSource = new byte[16];
        ByteUtils.bytesCopy(bodyBytes, this.authenticatorSource, off += 6, off + 15, 0);
        this.version = bodyBytes[off += 16];
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 4 - 1, 0);
        this.timestamp = ByteUtils.Bytes4ToInt(abyte0);
        off += 4;
    }

    @Override
    protected byte[] getBody() {
        byte[] bodyBytes = new byte[this.getCommandLength()];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.sourceAddr == null) {
            this.sourceAddr = "";
        }
        if (this.timestamp == 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            this.timestamp = (calendar.get(2) + 1) * 100000000 + calendar.get(5) * 1000000 + calendar.get(10) * 10000 + calendar.get(12) * 100 + calendar.get(13);
        }
        this.authenticatorSource = this.getAuthenticator(this.sourceAddr, this.sharedSecret, this.timestamp);
        int off = 0;
        ByteUtils.bytesCopy(this.sourceAddr.getBytes(), bodyBytes, 0, 5, off);
        ByteUtils.bytesCopy(this.authenticatorSource, bodyBytes, 0, 15, off += 6);
        bodyBytes[off += 16] = ByteUtils.intToByte(this.version);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.timestamp), bodyBytes, 0, 3, ++off);
        off += 4;
        return bodyBytes;
    }

    private byte[] getAuthenticator(String addr, String secret, int timestamp) {
        String strTimestamp = Integer.toString(timestamp);
        while (strTimestamp.length() < 10) {
            strTimestamp = "0" + strTimestamp;
        }
        byte[] buffer = new byte[15 + secret.length() + 10];
        Arrays.fill(buffer, (byte)0);
        int off = 0;
        ByteUtils.bytesCopy(addr.getBytes(), buffer, 0, 5, off);
        off += 6;
        ByteUtils.bytesCopy(secret.getBytes(), buffer, 0, secret.length() - 1, off += 9);
        ByteUtils.bytesCopy(strTimestamp.getBytes(), buffer, 0, strTimestamp.length() - 1, off += secret.length());
        off += 10;
        return Md5Utils.md5(buffer);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPConnectMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("sourceAddr=" + this.sourceAddr + ",");
        sb.append("authenticatorSource=" + this.authenticatorSource + ",");
        sb.append("version=" + this.version + ",");
        sb.append("timestamp=" + this.timestamp + "]");
        return sb.toString();
    }
}

