/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.util.Arrays;

public class CMPPBaseMessage
implements Message {
    public static final int SZ_HEADER = 12;
    private int totalLength;
    private int commandId;
    private int commandLength;
    private int sequenceId;
    protected Object extId;

    public CMPPBaseMessage(int commandId, int commandLength) {
        this.commandId = commandId;
        this.commandLength = commandLength;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public int getCommandLength() {
        return this.commandLength;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int value) {
        this.sequenceId = value;
    }

    public Object getExtId() {
        return this.extId;
    }

    public void setExtId(Object extId) {
        this.extId = extId;
    }

    public boolean fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return false;
        }
        if (bytes.length < 12) {
            return false;
        }
        byte[] headBytes = new byte[4];
        int offset = 0;
        ByteUtils.bytesCopy(bytes, headBytes, offset, offset + 3, 0);
        this.totalLength = ByteUtils.Bytes4ToInt(headBytes);
        ByteUtils.bytesCopy(bytes, headBytes, offset += 4, offset + 3, 0);
        this.commandId = ByteUtils.Bytes4ToInt(headBytes);
        ByteUtils.bytesCopy(bytes, headBytes, offset += 4, offset + 3, 0);
        this.sequenceId = ByteUtils.Bytes4ToInt(headBytes);
        if (this.totalLength - 12 < this.commandLength) {
            return false;
        }
        byte[] bodyBytes = new byte[this.totalLength - 12];
        ByteUtils.bytesCopy(bytes, bodyBytes, 12, bodyBytes.length - 1, 0);
        this.setBody(bodyBytes);
        return true;
    }

    public byte[] toBytes() throws Exception {
        byte[] bodyBytes = this.getBody();
        this.totalLength = 12 + bodyBytes.length;
        byte[] bytes = new byte[this.totalLength];
        Arrays.fill(bytes, (byte)0);
        int offset = 0;
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.totalLength), bytes, 0, 3, offset);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.commandId), bytes, 0, 3, offset += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.sequenceId), bytes, 0, 3, offset += 4);
        ByteUtils.bytesCopy(bodyBytes, bytes, 0, bodyBytes.length - 1, offset += 4);
        return bytes;
    }

    protected void setBody(byte[] bodyBytes) throws Exception {
    }

    protected byte[] getBody() throws Exception {
        return new byte[0];
    }

    protected String plus86(String mobile) {
        if (mobile == null || mobile.trim().length() == 0) {
            return "";
        }
        if (mobile.startsWith("86")) {
            return mobile;
        }
        if (mobile.startsWith("+86")) {
            return mobile.substring(1);
        }
        return "86" + mobile;
    }

    protected String minus86(String mobile) {
        return this.plus86(mobile);
    }

    public String sequenceString() {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        byte[] seqBytes = new byte[8];
        System.arraycopy(ByteUtils.intToBytes4(this.sequenceId), offset, seqBytes, 4, 4);
        buffer.append(ByteUtils.Bytes8ToLong(seqBytes));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CMPPBaseMessage:[sequenceId=").append(this.sequenceString()).append(",").append("commandId=").append(this.commandId).append("]");
        return buffer.toString();
    }
}

