/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp;

import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.Reader;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPConstants;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMPPReader
implements Reader {
    protected DataInputStream in;

    public CMPPReader(InputStream is) {
        this.in = new DataInputStream(is);
    }

    @Override
    public Message read() throws IOException {
        byte[] header = new byte[12];
        byte[] cmdBytes = null;
        this.readBytes(header, 0, 12);
        int cmdLen = ByteUtils.Bytes4ToInt(header);
        if (cmdLen > 8096 || cmdLen < 12) {
            throw new IOException("read stream error,cmdLen=" + cmdLen + ",close connection");
        }
        cmdBytes = new byte[cmdLen];
        System.arraycopy(header, 0, cmdBytes, 0, 12);
        this.readBytes(cmdBytes, 12, cmdLen - 12);
        try {
            CMPPBaseMessage baseMsg = CMPPConstants.fromBytes(cmdBytes);
            return baseMsg;
        }
        catch (Exception e) {
            throw new IOException("build CMPPBaseMessage error:" + e.getMessage());
        }
    }

    private void readBytes(byte[] bytes, int offset, int len) throws IOException {
        this.in.readFully(bytes, offset, len);
    }
}

