/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp;

import cn.chenzw.sms.core.Connection;
import cn.chenzw.sms.core.Reader;
import cn.chenzw.sms.core.Session;
import cn.chenzw.sms.core.Writer;
import cn.chenzw.sms.core.protocol.cmpp.CMPPReader;
import cn.chenzw.sms.core.protocol.cmpp.CMPPSession;
import cn.chenzw.sms.core.protocol.cmpp.CMPPWriter;
import java.io.InputStream;
import java.io.OutputStream;

public class CMPPConnection
extends Connection {
    public static final byte MT = 0;
    public static final byte MO = 1;
    public static final byte MT_MO = 2;
    private String sourceAddr;
    private String password;
    private byte loginMode;
    private byte version;

    public CMPPConnection() {
        this.setLoginMode((byte)2);
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String value) {
        this.sourceAddr = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public byte getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(byte loginMode) {
        this.loginMode = loginMode;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    protected Session createSession() {
        return new CMPPSession(this, false);
    }

    @Override
    protected Writer createWriter(OutputStream output) {
        return new CMPPWriter(output);
    }

    @Override
    protected Reader createReader(InputStream input) {
        return new CMPPReader(input);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("cmpp:[sourceAddr=").append(this.sourceAddr).append(",").append("host=").append(this.getHost()).append(",").append("port=").append(this.getPort()).append(",").append("password=").append(this.password).append(",").append("loginMode=").append(this.loginMode).append("]");
        return buffer.toString();
    }
}

