/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core;

import cn.chenzw.sms.core.Callback;
import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.Reader;
import cn.chenzw.sms.core.Session;
import cn.chenzw.sms.core.Writer;
import cn.chenzw.sms.core.support.callback.ConnectionCallback;
import cn.chenzw.sms.core.support.callback.SubmitCallback;
import cn.chenzw.sms.core.support.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Connection
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(Connection.class);
    private String host;
    private int port;
    private Socket socket;
    private SafeThread heartbeat;
    private SafeThread receiver;
    private boolean autoReconnect = true;
    private boolean keepAlive = true;
    private int keepAliveInterval = 9000;
    private int sendInterval = 50;
    private Reader in;
    private Writer out;
    private Queue<Message> queue = new LinkedBlockingQueue<Message>();
    private Session session;
    private List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();

    public Socket getSocket() {
        return this.socket;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean value) {
        this.keepAlive = value;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
    }

    public int getSendInterval() {
        return this.sendInterval;
    }

    public void setSendInterval(int sendInterval) {
        this.sendInterval = sendInterval;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public void registerCallbackHandler(Callback callback) {
        this.callbacks.add(callback);
    }

    public List<Callback> getRegistedCallbackHandler() {
        return this.callbacks;
    }

    public Session getSession() {
        return this.session;
    }

    public void send(Message message) {
        if (!this.isConnected()) {
            this.queue.offer(message);
        } else {
            Message msg = this.queue.poll();
            if (msg != null) {
                this.send(msg);
            }
            try {
                this.out.write(message);
                this.onSend(message);
            }
            catch (IOException ex) {
                this.queue.offer(message);
                this.disconnect();
                this.onError("socket connection send msg fail,retry:" + message, ex);
            }
        }
    }

    public void connect(String host, int port) {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public void connect() {
        try {
            if (StringUtils.isBlank(this.host)) {
                throw new IllegalArgumentException("host is null\uff01");
            }
            if (this.port <= 0 || this.port > 65535) {
                log.error(String.format("port error:%d", this.port));
                throw new IndexOutOfBoundsException(String.format("port error:%d", this.port));
            }
            if (!this.isConnected()) {
                this.socket = new Socket();
                this.socket.setKeepAlive(this.keepAlive);
                this.socket.connect(new InetSocketAddress(this.host, this.port));
                this.out = this.createWriter(this.socket.getOutputStream());
                this.in = this.createReader(this.socket.getInputStream());
                this.startThreads();
                this.onConnect();
            }
        }
        catch (Exception ex) {
            this.onError("socket connect failure", ex);
        }
    }

    public void disconnect() {
        this.killThreads();
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException ex) {
                log.error("socket input close failure", (Throwable)ex);
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException ex) {
                log.error("socket outp close failure", (Throwable)ex);
            }
            try {
                this.socket.close();
                this.socket = null;
                this.in = null;
                this.out = null;
            }
            catch (IOException ex) {
                log.error("socket close failure", (Throwable)ex);
            }
        }
        this.onDisconnect();
    }

    @Override
    public void close() {
        this.queue.clear();
        this.autoReconnect = false;
        if (this.isConnected()) {
            this.disconnect();
        }
        this.onClose();
    }

    protected abstract Session createSession();

    protected abstract Writer createWriter(OutputStream var1);

    protected abstract Reader createReader(InputStream var1);

    protected void heartbeat() throws IOException {
        Session session = this.getSession();
        if (session != null && session.isAuthenticated()) {
            session.heartbeat();
        }
    }

    protected void onReceive(Message message) throws IOException {
        Session session;
        log.debug("recv: {} ", (Object)message);
        if (message != null && (session = this.getSession()) != null) {
            session.process(message);
        }
    }

    protected void onSend(Message message) throws IOException {
        for (Callback callback : this.callbacks) {
            if (!(callback instanceof SubmitCallback)) continue;
            ((SubmitCallback)callback).onSend(this, message);
        }
        log.debug("send: {}", (Object)message);
    }

    protected void onError(String message) {
        log.error(String.format("%s host=%s,port=%d", message, this.getHost(), this.getPort()));
    }

    protected void onError(String message, Exception error) {
        for (Callback callback : this.callbacks) {
            callback.onError(this, error, message);
        }
        log.error(String.format("%s host=%s,port=%d", message, this.getHost(), this.getPort()), (Throwable)error);
    }

    protected void onConnect() {
        for (Callback callback : this.callbacks) {
            if (!(callback instanceof ConnectionCallback)) continue;
            ((ConnectionCallback)callback).onConnection(this);
        }
        log.debug(String.format("socket connect success host=%s,port=%d %tc%n", this.getHost(), this.getPort(), new Date()));
        if (this.session == null) {
            this.session = this.createSession();
        }
        if (this.session.authenticate()) {
            this.sendQueue();
        }
    }

    protected void onDisconnect() {
        for (Callback callback : this.callbacks) {
            if (!(callback instanceof ConnectionCallback)) continue;
            ((ConnectionCallback)callback).onDisconnect(this);
        }
        log.debug(String.format("socket disconnect success host=%s,port=%d %tc%n", this.getHost(), this.getPort(), new Date()));
        if (this.autoReconnect) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connect();
        }
    }

    protected void onClose() {
        log.debug(String.format("socket close success host=%s,port=%d %tc%n", this.getHost(), this.getPort(), new Date()));
    }

    protected void sendQueue() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Connection.this.sendQueue(Connection.this.sendInterval);
            }
        }, "queue");
        t.setDaemon(true);
        t.start();
    }

    private void sendQueue(int speed) {
        while (this.isConnected()) {
            Message msg = this.queue.poll();
            if (msg != null) {
                this.send(msg);
                try {
                    Thread.sleep(speed);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.queue.size() > 0) continue;
        }
    }

    private void startThreads() {
        if (this.keepAlive && this.keepAliveInterval > 0) {
            this.heartbeat = new SafeThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(Connection.this.keepAliveInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Connection.this.isConnected()) {
                        try {
                            if (Connection.this.queue.isEmpty()) {
                                Connection.this.heartbeat();
                            }
                        }
                        catch (IOException ex) {
                            log.error("heartbeat", (Throwable)ex);
                        }
                    }
                }
            }, "heartbeat");
            this.heartbeat.start();
        }
        this.receiver = new SafeThread(new Runnable(){

            @Override
            public void run() {
                if (Connection.this.isConnected()) {
                    try {
                        Message msg = Connection.this.in.read();
                        if (msg != null) {
                            Connection.this.onReceive(msg);
                        } else {
                            Connection.this.disconnect();
                            Connection.this.onError("socket connection receive msg null");
                        }
                    }
                    catch (IOException ex) {
                        if (Connection.this != null) {
                            Connection.this.disconnect();
                        }
                        Connection.this.onError("socket connection receive msg error: " + ex.getMessage(), ex);
                    }
                }
            }
        }, "receiver");
        this.receiver.start();
    }

    private void killThreads() {
        if (this.heartbeat != null) {
            this.heartbeat.kill();
            this.heartbeat = null;
        }
        if (this.receiver != null) {
            this.receiver.kill();
            this.receiver = null;
        }
    }

    private final class SafeThread
    extends Thread {
        private boolean alive;

        public SafeThread(Runnable target, String name) {
            super(target, name);
            this.alive = true;
            this.setDaemon(false);
        }

        public void kill() {
            this.alive = false;
        }

        @Override
        public final void run() {
            while (this.alive) {
                try {
                    super.run();
                }
                catch (Exception ex) {
                    log.error("thread error 1", (Throwable)ex);
                }
                catch (Throwable t) {
                    log.error("thread error 2", t);
                }
            }
        }
    }
}

