/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;

public class SMGPSubmitRespMessage
extends SMGPBaseMessage {
    private byte[] msgId;
    private int status;

    public SMGPSubmitRespMessage() {
        this.commandId = -2147483646;
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int offset = 0;
        this.msgId = new byte[10];
        System.arraycopy(bodyBytes, offset, this.msgId, 0, 10);
        this.status = ByteUtils.byte2int(bodyBytes, offset += 10);
        return offset += 4;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int len = 14;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        System.arraycopy(this.msgId, 0, bodyBytes, offset, 10);
        ByteUtils.int2byte(this.status, bodyBytes, offset += 10);
        offset += 4;
        return bodyBytes;
    }

    public byte[] getMsgId() {
        return this.msgId;
    }

    public void setMsgId(byte[] msgId) {
        this.msgId = msgId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String msgIdString() {
        return ByteUtils.byteArrayToHexString(this.msgId);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPSubmitRespMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgId=").append(this.msgIdString()).append(",");
        buffer.append("extId=").append(this.extId).append(",");
        buffer.append("status=").append(this.status).append("]");
        return buffer.toString();
    }
}

