/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.tlv.TLVByte;
import cn.chenzw.sms.core.protocol.smgp.tlv.TLVString;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.smgp.util.MsgUtils;

public class SMGPSubmitMessage
extends SMGPBaseMessage {
    private byte msgType = (byte)6;
    private byte needReport = 1;
    private byte priority;
    private String serviceId = "";
    private String feeType = "00";
    private String feeCode = "000000";
    private String fixedFee = "000000";
    private byte msgFmt;
    private String validTime = "";
    private String atTime = "";
    private String srcTermId = "";
    private String chargeTermId = "";
    private byte destTermIdCount;
    private String[] destTermIdArray;
    private int msgLength;
    private String msgContent;
    private byte[] bMsgContent;
    private String reserve = "";
    private TLVByte tpPid = new TLVByte(1);
    private TLVByte tpUdhi = new TLVByte(2);
    private TLVString linkId = new TLVString(3);
    private TLVString msgSrc = new TLVString(16);
    private TLVByte chargeUserType = new TLVByte(4);
    private TLVByte chargeTermType = new TLVByte(5);
    private TLVString chargeTermPseudo = new TLVString(6);
    private TLVByte destTermType = new TLVByte(7);
    private TLVString destTermPseudo = new TLVString(8);
    private TLVByte pkTotal = new TLVByte(9);
    private TLVByte pkNumber = new TLVByte(10);
    private TLVByte submitMsgType = new TLVByte(11);
    private TLVByte spDealResult = new TLVByte(12);
    private TLVString mServiceId = new TLVString(18);

    public SMGPSubmitMessage() {
        this.commandId = 2;
        this.registerOptional(this.tpPid);
        this.registerOptional(this.tpUdhi);
        this.registerOptional(this.linkId);
        this.registerOptional(this.msgSrc);
        this.registerOptional(this.chargeUserType);
        this.registerOptional(this.chargeTermType);
        this.registerOptional(this.chargeTermPseudo);
        this.registerOptional(this.destTermType);
        this.registerOptional(this.destTermPseudo);
        this.registerOptional(this.pkTotal);
        this.registerOptional(this.pkNumber);
        this.registerOptional(this.submitMsgType);
        this.registerOptional(this.spDealResult);
        this.registerOptional(this.mServiceId);
    }

    public void setTpPid(byte value) {
        this.tpPid.setValue(value);
    }

    public byte getTpPid() {
        return this.tpPid.getValue();
    }

    public void setTpUdhi(byte value) {
        this.tpUdhi.setValue(value);
    }

    public byte getTpUdhi() {
        return this.tpUdhi.getValue();
    }

    public void setLinkId(String value) {
        this.linkId.setValue(value);
    }

    public String getLinkId() {
        return this.linkId.getValue();
    }

    public void setMsgSrc(String value) {
        this.msgSrc.setValue(value);
    }

    public String getMsgSrc() {
        return this.msgSrc.getValue();
    }

    public void setChargeUserType(byte value) {
        this.chargeUserType.setValue(value);
    }

    public byte getChargeUserType() {
        return this.chargeUserType.getValue();
    }

    public void setChargeTermType(byte value) {
        this.chargeTermType.setValue(value);
    }

    public byte getChargeTermType() {
        return this.chargeTermType.getValue();
    }

    public void setChargeTermPseudo(String value) {
        this.chargeTermPseudo.setValue(value);
    }

    public String getChargeTermPseudo() {
        return this.chargeTermPseudo.getValue();
    }

    public void setDestTermType(byte value) {
        this.destTermType.setValue(value);
    }

    public byte getDestTermType() {
        return this.destTermType.getValue();
    }

    public void setDestTermPseudo(String value) {
        this.destTermPseudo.setValue(value);
    }

    public String getDestTermPseudo() {
        return this.destTermPseudo.getValue();
    }

    public void setPkTotal(byte value) {
        this.pkTotal.setValue(value);
    }

    public byte getPkTotal() {
        return this.pkTotal.getValue();
    }

    public void setPkNumber(byte value) {
        this.pkNumber.setValue(value);
    }

    public byte getPkNumber() {
        return this.pkNumber.getValue();
    }

    public void setSubmitMsgType(byte value) {
        this.submitMsgType.setValue(value);
    }

    public byte getSubmitMsgType() {
        return this.submitMsgType.getValue();
    }

    public void setSpDealResult(byte value) {
        this.spDealResult.setValue(value);
    }

    public byte getSpDealResult() {
        return this.spDealResult.getValue();
    }

    public void setMServiceId(String value) {
        this.mServiceId.setValue(value);
    }

    public String getMServiceId() {
        return this.mServiceId.getValue();
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int offset = 0;
        byte[] tmp = null;
        this.msgType = bodyBytes[offset];
        this.needReport = bodyBytes[++offset];
        this.priority = bodyBytes[++offset];
        tmp = new byte[10];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 10);
        this.serviceId = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[2];
        System.arraycopy(bodyBytes, offset += 10, tmp, 0, 2);
        this.feeType = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[6];
        System.arraycopy(bodyBytes, offset += 2, tmp, 0, 6);
        this.feeCode = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[6];
        System.arraycopy(bodyBytes, offset += 6, tmp, 0, 6);
        this.fixedFee = new String(ByteUtils.rtrimBytes(tmp));
        this.msgFmt = bodyBytes[offset += 6];
        tmp = new byte[17];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 17);
        this.validTime = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[17];
        System.arraycopy(bodyBytes, offset += 17, tmp, 0, 17);
        this.atTime = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 17, tmp, 0, 21);
        this.srcTermId = new String(ByteUtils.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 21, tmp, 0, 21);
        this.chargeTermId = new String(ByteUtils.rtrimBytes(tmp));
        this.destTermIdCount = bodyBytes[offset += 21];
        ++offset;
        if (this.destTermIdCount >= 100 || this.destTermIdCount <= 0) {
            throw new RuntimeException("destTermIdCount must be in [1,99],but " + this.destTermIdCount);
        }
        this.destTermIdArray = new String[this.destTermIdCount];
        for (int i = 0; i < this.destTermIdCount; ++i) {
            tmp = new byte[21];
            System.arraycopy(bodyBytes, offset, tmp, 0, 21);
            offset += 21;
            this.destTermIdArray[i] = new String(ByteUtils.rtrimBytes(tmp));
        }
        int b = bodyBytes[offset];
        ++offset;
        int n = this.msgLength = b >= 0 ? b : 256 + b;
        if (this.msgLength > 0) {
            tmp = new byte[this.msgLength];
            System.arraycopy(bodyBytes, offset, tmp, 0, this.msgLength);
            offset += this.msgLength;
            this.bMsgContent = tmp;
            this.msgContent = MsgUtils.formatMsg(this.bMsgContent, this.msgFmt);
            this.msgContent = this.msgContent.trim();
        }
        tmp = new byte[8];
        System.arraycopy(bodyBytes, offset, tmp, 0, 8);
        this.reserve = new String(ByteUtils.rtrimBytes(tmp));
        return offset += 8;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int len = 105 + 21 * this.destTermIdCount + 1 + this.msgLength + 8;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        bodyBytes[offset] = this.msgType;
        bodyBytes[++offset] = this.needReport;
        bodyBytes[++offset] = this.priority;
        ByteUtils.rfillBytes(this.serviceId.getBytes(), 10, bodyBytes, ++offset);
        ByteUtils.rfillBytes(this.feeType.getBytes(), 2, bodyBytes, offset += 10);
        ByteUtils.rfillBytes(this.feeCode.getBytes(), 6, bodyBytes, offset += 2);
        ByteUtils.rfillBytes(this.fixedFee.getBytes(), 6, bodyBytes, offset += 6);
        bodyBytes[offset += 6] = this.msgFmt;
        ByteUtils.rfillBytes(this.validTime.getBytes(), 17, bodyBytes, ++offset);
        ByteUtils.rfillBytes(this.atTime.getBytes(), 17, bodyBytes, offset += 17);
        ByteUtils.rfillBytes(this.srcTermId.getBytes(), 21, bodyBytes, offset += 17);
        ByteUtils.rfillBytes(this.chargeTermId.getBytes(), 21, bodyBytes, offset += 21);
        bodyBytes[offset += 21] = this.destTermIdCount;
        ++offset;
        for (int i = 0; i < this.destTermIdCount; ++i) {
            ByteUtils.rfillBytes(this.destTermIdArray[i].getBytes(), 21, bodyBytes, offset);
            offset += 21;
        }
        bodyBytes[offset] = (byte)this.msgLength;
        ++offset;
        if (this.bMsgContent == null && this.msgContent != null) {
            try {
                this.bMsgContent = MsgUtils.formatMsg(this.msgContent, this.msgFmt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.bMsgContent != null) {
            ByteUtils.rfillBytes(this.bMsgContent, this.msgLength, bodyBytes, offset);
        }
        ByteUtils.rfillBytes(this.reserve.getBytes(), 8, bodyBytes, offset += this.msgLength);
        offset += 8;
        return bodyBytes;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public void setMsgType(byte msgType) {
        this.msgType = msgType;
    }

    public byte getNeedReport() {
        return this.needReport;
    }

    public void setNeedReport(byte needReport) {
        this.needReport = needReport;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeCode() {
        return this.feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getFixedFee() {
        return this.fixedFee;
    }

    public void setFixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
    }

    public byte getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(byte msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getValidTime() {
        return this.validTime;
    }

    public void setValidTime(String validTime) {
        this.validTime = validTime;
    }

    public String getAtTime() {
        return this.atTime;
    }

    public void setAtTime(String atTime) {
        this.atTime = atTime;
    }

    public String getSrcTermId() {
        return this.srcTermId;
    }

    public void setSrcTermId(String srcTermId) {
        this.srcTermId = srcTermId;
    }

    public String getChargeTermId() {
        return this.chargeTermId;
    }

    public void setChargeTermId(String chargeTermId) {
        this.chargeTermId = chargeTermId;
    }

    public byte getDestTermIdCount() {
        return this.destTermIdCount;
    }

    public void setDestTermIdCount(byte destTermIdCount) {
        this.destTermIdCount = destTermIdCount;
    }

    public String[] getDestTermIdArray() {
        return this.destTermIdArray;
    }

    public void setDestTermIdArray(String[] destTermIdArray) {
        this.destTermIdArray = destTermIdArray;
        this.destTermIdCount = (byte)(destTermIdArray == null ? 0 : destTermIdArray.length);
    }

    public String getMsgContent() {
        if (this.msgContent != null) {
            return this.msgContent;
        }
        if (this.bMsgContent != null) {
            String msg = null;
            try {
                msg = MsgUtils.formatMsg(this.bMsgContent, this.msgFmt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return msg;
        }
        return null;
    }

    public void setMsgContent(String msgContent) {
        if (msgContent != null) {
            this.bMsgContent = msgContent.getBytes();
            this.msgContent = msgContent;
            this.msgLength = msgContent.getBytes().length == msgContent.length() ? msgContent.length() : msgContent.length() * 2;
        } else {
            this.msgLength = 0;
            this.bMsgContent = null;
            this.msgContent = null;
        }
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int msgLength) {
        this.msgLength = msgLength;
    }

    public byte[] getBMsgContent() {
        return this.bMsgContent;
    }

    public void setBMsgContent(byte[] msgContent) {
        this.bMsgContent = msgContent;
        this.msgLength = this.bMsgContent == null ? 0 : this.bMsgContent.length;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPSubmitMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgType=").append(this.msgType).append(",");
        buffer.append("needReport=").append(this.needReport).append(",");
        buffer.append("priority=").append(this.priority).append(",");
        buffer.append("serviceId=").append(this.serviceId).append(",");
        buffer.append("feeType=").append(this.feeType).append(",");
        buffer.append("feeCode=").append(this.feeCode).append(",");
        buffer.append("fixedFee=").append(this.fixedFee).append(",");
        buffer.append("msgFmt=").append(this.msgFmt).append(",");
        buffer.append("validTime=").append(this.validTime).append(",");
        buffer.append("atTime=").append(this.atTime).append(",");
        buffer.append("srcTermId=").append(this.srcTermId).append(",");
        buffer.append("chargeTermId=").append(this.chargeTermId).append(",");
        buffer.append("destTermIdArray={");
        for (int i = 0; i < this.destTermIdCount; ++i) {
            if (i == 0) {
                buffer.append(this.destTermIdArray[i]);
                continue;
            }
            buffer.append(";" + this.destTermIdArray[i]);
        }
        buffer.append("},");
        buffer.append("msgLength=").append(this.msgLength).append(",");
        buffer.append("msgContent=").append(this.getMsgContent()).append("]");
        buffer.append("extId=").append(this.extId).append(",");
        return buffer.toString();
    }
}

