/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp.message;

import cn.chenzw.sms.core.protocol.smgp.message.SMGPActiveTestMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPActiveTestRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPDeliverMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPDeliverRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPExitMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPExitRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPLoginMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPLoginRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPSubmitMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPSubmitRespMessage;
import cn.chenzw.sms.core.protocol.smgp.util.ByteUtils;

public class SMGPConstants {
    public static final int SMGP_LOGIN = 1;
    public static final int SMGP_LOGIN_RESP = -2147483647;
    public static final int SMGP_SUBMIT = 2;
    public static final int SMGP_SUBMIT_RESP = -2147483646;
    public static final int SMGP_DELIVER = 3;
    public static final int SMGP_DELIVER_RESP = -2147483645;
    public static final int SMGP_ACTIVE_TEST = 4;
    public static final int SMGP_ACTIVE_TEST_RESP = -2147483644;
    public static final int SMGP_EXIT_TEST = 6;
    public static final int SMGP_EXIT_RESP = -2147483642;
    public static final short OPT_TP_PID = 1;
    public static final short OPT_TP_UDHI = 2;
    public static final short OPT_LINK_ID = 3;
    public static final short OPT_CHARGE_USER_TYPE = 4;
    public static final short OPT_CHARGE_TERM_TYPE = 5;
    public static final short OPT_CHARGE_TERM_PSEUDO = 6;
    public static final short OPT_DEST_TERM_TYPE = 7;
    public static final short OPT_DEST_TERM_PSEUDO = 8;
    public static final short OPT_PK_TOTAL = 9;
    public static final short OPT_PK_NUMBER = 10;
    public static final short OPT_SUBMIT_MSG_TYPE = 11;
    public static final short OPT_SP_DEAL_RESULT = 12;
    public static final short OPT_SRC_TERM_TYPE = 13;
    public static final short OPT_SRC_TERM_PSEUDO = 14;
    public static final short OPT_NODES_COUNT = 15;
    public static final short OPT_MSG_SRC = 16;
    public static final short OPT_SRC_TYPE = 17;
    public static final short OPT_M_SERVICE_ID = 18;

    public static SMGPBaseMessage fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        if (bytes.length < 12) {
            return null;
        }
        int commandLength = ByteUtils.byte2int(bytes, 0);
        int commandId = ByteUtils.byte2int(bytes, 4);
        SMGPBaseMessage baseMsg = null;
        switch (commandId) {
            case 1: {
                baseMsg = new SMGPLoginMessage();
                break;
            }
            case -2147483647: {
                baseMsg = new SMGPLoginRespMessage();
                break;
            }
            case 2: {
                baseMsg = new SMGPSubmitMessage();
                break;
            }
            case -2147483646: {
                baseMsg = new SMGPSubmitRespMessage();
                break;
            }
            case 3: {
                baseMsg = new SMGPDeliverMessage();
                break;
            }
            case -2147483645: {
                baseMsg = new SMGPDeliverRespMessage();
                break;
            }
            case 4: {
                baseMsg = new SMGPActiveTestMessage();
                break;
            }
            case -2147483644: {
                baseMsg = new SMGPActiveTestRespMessage();
                break;
            }
            case 6: {
                baseMsg = new SMGPExitMessage();
                break;
            }
            case -2147483642: {
                baseMsg = new SMGPExitRespMessage();
                break;
            }
            default: {
                baseMsg = new SMGPBaseMessage();
            }
        }
        baseMsg.fromBytes(bytes);
        return baseMsg;
    }
}

