/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.smgp;

import cn.chenzw.sms.core.Callback;
import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.Session;
import cn.chenzw.sms.core.protocol.smgp.SMGPConnection;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPActiveTestMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPActiveTestRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPBaseMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPDeliverMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPDeliverRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPExitMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPExitRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPLoginMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPLoginRespMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPReportData;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPSubmitMessage;
import cn.chenzw.sms.core.protocol.smgp.message.SMGPSubmitRespMessage;
import cn.chenzw.sms.core.protocol.smgp.util.Md5Utils;
import cn.chenzw.sms.core.protocol.smgp.util.SequenceGenerator;
import cn.chenzw.sms.core.support.callback.ConnectionCallback;
import cn.chenzw.sms.core.support.callback.SubmitCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(SMGPSession.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMddHHmmss");
    private SMGPConnection connection;
    private String sessionId;
    private boolean authenticated;
    private Object lock = new Object();
    private List<Callback> callbacks;
    private Map<Integer, Object> extIdCache;

    public SMGPSession(SMGPConnection connection, boolean authenticated) {
        this.connection = connection;
        this.sessionId = UUID.randomUUID().toString();
        this.authenticated = authenticated;
        this.callbacks = new CopyOnWriteArrayList<Callback>();
        this.extIdCache = new ConcurrentHashMap<Integer, Object>();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void submit(String content, String spNumber, String userNumber) {
        this.submit(null, content, spNumber, userNumber);
    }

    @Override
    public void submit(Object extId, String content, String spNumber, String userNumber) {
        SMGPSubmitMessage submit = new SMGPSubmitMessage();
        submit.setSrcTermId(spNumber);
        submit.setDestTermIdArray(new String[]{userNumber});
        submit.setMsgFmt((byte)8);
        byte[] bContent = null;
        try {
            bContent = content.getBytes("iso-10646-ucs-2");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (bContent != null && bContent.length <= 140) {
            submit.setBMsgContent(bContent);
            submit.setMsgFmt((byte)8);
            submit.setNeedReport((byte)1);
            submit.setServiceId("");
            submit.setAtTime("");
            submit.setNeedReport((byte)1);
            submit.setSequenceNumber(SequenceGenerator.nextSequence());
            submit.setExtId(extId);
            this.addExtIdCache(submit);
            this.send(submit);
        }
    }

    @Override
    public void heartbeat() {
        if (this.isAuthenticated()) {
            SMGPActiveTestMessage activeTest = new SMGPActiveTestMessage();
            activeTest.setSequenceNumber(SequenceGenerator.nextSequence());
            this.send(activeTest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate() {
        SMGPLoginMessage loginMsg = new SMGPLoginMessage();
        loginMsg.setClientId(this.connection.getClientId());
        loginMsg.setLoginMode(this.connection.getLoginMode());
        loginMsg.setVersion(this.connection.getVersion());
        String tmp = dateFormat.format(Calendar.getInstance().getTime());
        loginMsg.setTimestamp(Integer.parseInt(tmp));
        loginMsg.setClientAuth(Md5Utils.md5(this.connection.getClientId(), this.connection.getPassword(), tmp));
        loginMsg.setSequenceNumber(SequenceGenerator.nextSequence());
        this.send(loginMsg);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException ex) {
                this.setAuthenticated(false);
            }
        }
        return this.isAuthenticated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isAuthenticated()) {
            SMGPExitMessage exit = new SMGPExitMessage();
            exit.setSequenceNumber(SequenceGenerator.nextSequence());
            this.send(exit);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(6000L);
                }
                catch (InterruptedException ex) {
                    this.setAuthenticated(false);
                }
            }
        }
        this.connection.close();
    }

    @Override
    public void send(Message message) {
        this.connection.send(message);
    }

    @Override
    public void process(Message message) throws IOException {
        if (message instanceof SMGPBaseMessage) {
            SMGPBaseMessage baseMsg = (SMGPBaseMessage)message;
            baseMsg.setExtId(this.getExtIdFromCache(baseMsg));
            if (this.isAuthenticated()) {
                if (baseMsg instanceof SMGPActiveTestMessage) {
                    this.process((SMGPActiveTestMessage)baseMsg);
                } else if (baseMsg instanceof SMGPActiveTestRespMessage) {
                    this.process(baseMsg);
                } else if (baseMsg instanceof SMGPExitRespMessage) {
                    this.process((SMGPExitRespMessage)baseMsg);
                } else if (message instanceof SMGPSubmitRespMessage) {
                    this.process((SMGPSubmitRespMessage)message);
                } else if (message instanceof SMGPDeliverMessage) {
                    this.process((SMGPDeliverMessage)message);
                }
            } else if (baseMsg instanceof SMGPLoginRespMessage) {
                this.process((SMGPLoginRespMessage)baseMsg);
            } else {
                throw new IOException("the first packet was not SMGPBindRespMessage:" + baseMsg);
            }
        }
    }

    @Override
    public void registerCallbackHandler(Callback callback) {
        this.callbacks.add(callback);
    }

    private void process(SMGPActiveTestMessage msg) throws IOException {
        SMGPActiveTestRespMessage resp = new SMGPActiveTestRespMessage();
        resp.setSequenceNumber(msg.getSequenceNumber());
        this.send(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(SMGPLoginRespMessage rsp) throws IOException {
        List<Callback> globalCallbacks = this.connection.getRegistedCallbackHandler();
        Object object = this.lock;
        synchronized (object) {
            if (rsp.getStatus() == 0) {
                this.setAuthenticated(true);
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)globalCallback).onLoginSuccess(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)callback).onLoginSuccess(this.connection, rsp);
                }
                log.debug("smgp login success host={},port={},clientId={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getClientId()});
            } else {
                this.setAuthenticated(false);
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)globalCallback).onLoingFailure(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)callback).onLoingFailure(this.connection, rsp);
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                log.error("smgp login failure, host={} ,port={},clientId={},status={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getClientId(), rsp.getStatus()});
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(SMGPExitRespMessage msg) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.setAuthenticated(false);
            this.lock.notifyAll();
        }
        log.debug("smgp exist success host={},port={},clientId={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getClientId()});
    }

    private void process(SMGPSubmitRespMessage rsp) throws IOException {
        List<Callback> globalCallbacks = this.connection.getRegistedCallbackHandler();
        switch (rsp.getStatus()) {
            case 0: {
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)globalCallback).onSendSuccess(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)callback).onSendSuccess(this.connection, rsp);
                }
                break;
            }
            default: {
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)globalCallback).onSendFailure(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)callback).onSendFailure(this.connection, rsp);
                }
            }
        }
    }

    private void process(SMGPDeliverMessage msg) throws IOException {
        if (msg.getIsReport() == 1) {
            SMGPReportData sMGPReportData = msg.getReport();
        }
        SMGPDeliverRespMessage rsp = new SMGPDeliverRespMessage();
        rsp.setSequenceNumber(msg.getSequenceNumber());
        rsp.setMsgId(msg.getMsgId());
        rsp.setStatus(0);
        this.send(rsp);
    }

    private void setAuthenticated(boolean value) {
        this.authenticated = value;
    }

    private void addExtIdCache(SMGPSubmitMessage submitMessage) {
        this.extIdCache.put(submitMessage.getSequenceNumber(), submitMessage.getExtId());
    }

    private Object getExtIdFromCache(SMGPBaseMessage baseMsg) {
        return this.extIdCache.get(baseMsg.getSequenceNumber());
    }
}

