/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.util.Arrays;

public class CMPPSubmitRespMessage
extends CMPPBaseMessage {
    private long msgId = 0L;
    private int result = 0;

    public CMPPSubmitRespMessage() {
        super(-2147483644, 9);
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        byte[] abyte0 = new byte[21];
        int off = 0;
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 7, 0);
        this.msgId = ByteUtils.Bytes8ToLong(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 8, off, 0);
        this.result = ByteUtils.byteToInt(abyte0[0]);
        ++off;
    }

    @Override
    protected byte[] getBody() {
        int bodyLength = this.getCommandLength();
        byte[] bodyBytes = new byte[bodyLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.msgId == 0L) {
            this.msgId = 123456L;
        }
        int off = 0;
        ByteUtils.bytesCopy(ByteUtils.longToBytes8(this.msgId), bodyBytes, 0, 7, off);
        bodyBytes[off += 8] = ByteUtils.intToByte(this.result);
        ++off;
        return bodyBytes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPSubmitRespMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("msgId=" + this.extId + ",");
        sb.append("msgId=" + this.msgId + ",");
        sb.append("result=" + this.result + "]");
        return sb.toString();
    }
}

