/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class CMPPQueryRespMessage
extends CMPPBaseMessage {
    private String time = null;
    private int queryType = 0;
    private String queryCode = null;
    private int mtTLMsg = 0;
    private int mtTLUsr = 0;
    private int mtScs = 0;
    private int mtWT = 0;
    private int mtFL = 0;
    private int moScs = 0;
    private int moWT = 0;
    private int moFL = 0;

    public CMPPQueryRespMessage() {
        super(-2147483642, 51);
    }

    public int getMoFL() {
        return this.moFL;
    }

    public void setMoFL(int mofl) {
        this.moFL = mofl;
    }

    public int getMoScs() {
        return this.moScs;
    }

    public void setMoScs(int scs) {
        this.moScs = scs;
    }

    public int getMoWT() {
        return this.moWT;
    }

    public void setMoWT(int mowt) {
        this.moWT = mowt;
    }

    public int getMtFL() {
        return this.mtFL;
    }

    public void setMtFL(int mtfl) {
        this.mtFL = mtfl;
    }

    public int getMtScs() {
        return this.mtScs;
    }

    public void setMtScs(int scs) {
        this.mtScs = scs;
    }

    public int getMtTLMsg() {
        return this.mtTLMsg;
    }

    public void setMtTLMsg(int msg) {
        this.mtTLMsg = msg;
    }

    public int getMtTLUsr() {
        return this.mtTLUsr;
    }

    public void setMtTLUsr(int usr) {
        this.mtTLUsr = usr;
    }

    public int getMtWT() {
        return this.mtWT;
    }

    public void setMtWT(int mtwt) {
        this.mtWT = mtwt;
    }

    public String getQueryCode() {
        return this.queryCode;
    }

    public void setQueryCode(String queryCode) {
        this.queryCode = queryCode;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        byte[] abyte0 = new byte[21];
        int off = 0;
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 7, 0);
        this.time = new String(abyte0, 0, 8);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 8, off, 0);
        this.queryType = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 9, 0);
        this.queryCode = new String(abyte0, 0, 10);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 10, off + 3, 0);
        this.mtTLMsg = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.mtTLUsr = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.mtScs = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.mtWT = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.mtFL = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.moScs = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.moWT = ByteUtils.Bytes4ToInt(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 4, off + 3, 0);
        this.moFL = ByteUtils.Bytes4ToInt(abyte0);
        off += 4;
    }

    @Override
    protected byte[] getBody() {
        int bodyLength = this.getCommandLength();
        byte[] bodyBytes = new byte[bodyLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.time == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int timestamp = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
            this.time = String.valueOf(timestamp);
        }
        if (this.queryCode == null) {
            this.queryCode = "";
        }
        int off = 0;
        ByteUtils.bytesCopy(this.time.getBytes(), bodyBytes, 0, 7, off);
        bodyBytes[off += 8] = ByteUtils.intToByte(this.queryType);
        ByteUtils.bytesCopy(this.queryCode.getBytes(), bodyBytes, 0, 9, ++off);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.mtTLMsg), bodyBytes, 0, 3, off += 10);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.mtTLUsr), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.mtScs), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.mtWT), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.mtFL), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.moScs), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.moWT), bodyBytes, 0, 3, off += 4);
        ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.moFL), bodyBytes, 0, 3, off += 4);
        off += 4;
        return bodyBytes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPQueryRespMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("time=" + this.time + ",");
        sb.append("queryType=" + this.queryType + ",");
        sb.append("queryCode=" + this.queryCode + ",");
        sb.append("mtTLMsg=" + this.mtTLMsg + ",");
        sb.append("mtTLUsr=" + this.mtTLUsr + ",");
        sb.append("mtScs=" + this.mtScs + ",");
        sb.append("mtWT=" + this.mtWT + ",");
        sb.append("mtFL=" + this.mtFL + ",");
        sb.append("moScs=" + this.moScs + ",");
        sb.append("moWT=" + this.moWT + ",");
        sb.append("moFL=" + this.moFL + "]");
        return sb.toString();
    }
}

