/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class CMPPQueryMessage
extends CMPPBaseMessage {
    private String time = null;
    private int queryType = 0;
    private String queryCode = null;
    private String reserve = null;

    public CMPPQueryMessage() {
        super(6, 27);
    }

    public String getQueryCode() {
        return this.queryCode;
    }

    public void setQueryCode(String queryCode) {
        this.queryCode = queryCode;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        byte[] abyte0 = new byte[21];
        int off = 0;
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 7, 0);
        this.time = new String(abyte0, 0, 8);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 8, off, 0);
        this.queryType = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 9, 0);
        this.queryCode = new String(abyte0, 0, 10);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 10, off + 7, 0);
        this.reserve = new String(abyte0, 0, 8);
        off += 8;
    }

    @Override
    protected byte[] getBody() {
        int bodyLength = this.getCommandLength();
        byte[] bodyBytes = new byte[bodyLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.time == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int timestamp = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
            this.time = String.valueOf(timestamp);
        }
        if (this.queryCode == null) {
            this.queryCode = "";
        }
        if (this.reserve == null) {
            this.reserve = "";
        }
        int off = 0;
        ByteUtils.bytesCopy(this.time.getBytes(), bodyBytes, 0, 7, off);
        bodyBytes[off += 8] = ByteUtils.intToByte(this.queryType);
        ByteUtils.bytesCopy(this.queryCode.getBytes(), bodyBytes, 0, 9, ++off);
        ByteUtils.bytesCopy(this.reserve.getBytes(), bodyBytes, 0, 7, off += 10);
        off += 8;
        return bodyBytes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPQueryMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("time=" + this.time + ",");
        sb.append("queryType=" + this.queryType + ",");
        sb.append("queryCode=" + this.queryCode + ",");
        sb.append("reserve=" + this.reserve + "]");
        return sb.toString();
    }
}

