/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;
import cn.chenzw.sms.core.protocol.cmpp.util.MsgUtils;
import java.util.Arrays;

public class CMPPDeliverMessage
extends CMPPBaseMessage {
    private final int maxMsgLength0 = 160;
    private final int maxMsgLength1 = 140;
    private long msgId = 0L;
    private String destId = null;
    private String serviceId = null;
    private int tpPid = 0;
    private int tpUdhi = 0;
    private int msgFmt = 0;
    private String srcTerminalId = null;
    private int registeredDelivery = 0;
    private int msgLength = 0;
    private byte[] msgContent = null;
    private String reserved = null;
    private long reportMsgId = 0L;
    private String reportStat = null;
    private String reportSubmitTime = null;
    private String reportDoneTime = null;
    private String reportDestTerminalId = null;
    private int reportSMSCSequence = 0;

    public CMPPDeliverMessage() {
        super(5, 73);
    }

    public String getReportDestTerminalId() {
        return this.reportDestTerminalId;
    }

    public void setReportDestTerminalId(String reportDestTerminalId) {
        this.reportDestTerminalId = reportDestTerminalId;
    }

    public String getReportDoneTime() {
        return this.reportDoneTime;
    }

    public void setReportDoneTime(String reportDoneTime) {
        this.reportDoneTime = reportDoneTime;
    }

    public long getReportMsgId() {
        return this.reportMsgId;
    }

    public void setReportMsgId(long reportMsgId) {
        this.reportMsgId = reportMsgId;
    }

    public int getReportSMSCSequence() {
        return this.reportSMSCSequence;
    }

    public void setReportSMSCSequence(int reportSMSCSequence) {
        this.reportSMSCSequence = reportSMSCSequence;
    }

    public String getReportStat() {
        return this.reportStat;
    }

    public void setReportStat(String reportStat) {
        this.reportStat = reportStat;
    }

    public String getReportSubmitTime() {
        return this.reportSubmitTime;
    }

    public void setReportSubmitTime(String reportSubmitTime) {
        this.reportSubmitTime = reportSubmitTime;
    }

    public String getDestId() {
        return this.destId;
    }

    public void setDestId(String destId) {
        this.destId = destId;
    }

    public byte[] getMsgContent() {
        return this.msgContent;
    }

    public int getMsgFmt() {
        return this.msgFmt;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public int getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(int registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
        if (registeredDelivery == 1) {
            this.msgLength = 60;
            this.msgFmt = 4;
        }
    }

    public String getReserved() {
        return this.reserved;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getSrcTerminalId() {
        return this.srcTerminalId;
    }

    public void setSrcTerminalId(String srcTerminalId) {
        this.srcTerminalId = srcTerminalId;
    }

    public int getTpPid() {
        return this.tpPid;
    }

    public void setTpPid(int pid) {
        this.tpPid = pid;
    }

    public int getTpUdhi() {
        return this.tpUdhi;
    }

    public void setTpUdhi(int udhi) {
        this.tpUdhi = udhi;
    }

    public void setMsgText(String msgText, int msgFmt) {
        byte[] msgBytes = MsgUtils.getMsgBytes(msgText, msgFmt);
        this.msgFmt = msgFmt;
        this.msgContent = msgBytes;
        this.msgLength = MsgUtils.calMsgLength(this.msgContent, msgFmt, 160, 140);
    }

    @Override
    protected void setBody(byte[] bodyBytes) {
        byte[] abyte0 = new byte[21];
        int off = 0;
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off, off + 7, 0);
        this.msgId = ByteUtils.Bytes8ToLong(abyte0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 8, off + 20, 0);
        this.destId = new String(abyte0, 0, 21);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 21, off + 9, 0);
        this.serviceId = new String(abyte0, 0, 10);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 10, off, 0);
        this.tpPid = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.tpUdhi = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.msgFmt = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off + 20, 0);
        this.srcTerminalId = new String(abyte0, 0, 21);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += 21, off, 0);
        this.registeredDelivery = ByteUtils.byteToInt(abyte0[0]);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, ++off, off, 0);
        this.msgLength = ByteUtils.byteToInt(abyte0[0]);
        this.msgContent = new byte[this.msgLength];
        ByteUtils.bytesCopy(bodyBytes, this.msgContent, ++off, off + this.msgLength - 1, 0);
        Arrays.fill(abyte0, (byte)0);
        ByteUtils.bytesCopy(bodyBytes, abyte0, off += this.msgLength, off + 7, 0);
        this.reserved = new String(abyte0, 0, 8);
        off += 8;
        if (this.registeredDelivery == 1) {
            off = 0;
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off, off + 7, 0);
            this.reportMsgId = ByteUtils.Bytes8ToLong(abyte0);
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off += 8, off + 6, 0);
            this.reportStat = new String(abyte0, 0, 7);
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off += 7, off + 9, 0);
            this.reportSubmitTime = new String(abyte0, 0, 10);
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off += 10, off + 9, 0);
            this.reportDoneTime = new String(abyte0, 0, 10);
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off += 10, off + 20, 0);
            this.reportDestTerminalId = new String(abyte0, 0, 21);
            Arrays.fill(abyte0, (byte)0);
            ByteUtils.bytesCopy(this.msgContent, abyte0, off += 21, off + 3, 0);
            this.reportSMSCSequence = ByteUtils.Bytes4ToInt(abyte0);
            off += 4;
        }
    }

    @Override
    protected byte[] getBody() {
        byte[] bodyBytes = new byte[73 + this.msgLength];
        Arrays.fill(bodyBytes, (byte)0);
        if (this.msgId == 0L) {
            this.msgId = 123456L;
        }
        if (this.destId == null) {
            this.destId = "";
        }
        if (this.serviceId == null) {
            this.serviceId = "";
        }
        if (this.srcTerminalId == null) {
            this.srcTerminalId = "";
        }
        if (this.reserved == null) {
            this.reserved = "";
        }
        if (this.reportStat == null) {
            this.reportStat = "";
        }
        if (this.reportSubmitTime == null) {
            this.reportSubmitTime = "";
        }
        if (this.reportDoneTime == null) {
            this.reportDoneTime = "";
        }
        if (this.reportDestTerminalId == null) {
            this.reportDestTerminalId = "";
        }
        int off = 0;
        ByteUtils.bytesCopy(ByteUtils.longToBytes8(this.msgId), bodyBytes, 0, 7, off);
        ByteUtils.bytesCopy(this.destId.getBytes(), bodyBytes, 0, 20, off += 8);
        ByteUtils.bytesCopy(this.serviceId.getBytes(), bodyBytes, 0, 9, off += 21);
        bodyBytes[off += 10] = ByteUtils.intToByte(this.tpPid);
        bodyBytes[++off] = ByteUtils.intToByte(this.tpUdhi);
        bodyBytes[++off] = ByteUtils.intToByte(this.msgFmt);
        ByteUtils.bytesCopy(this.srcTerminalId.getBytes(), bodyBytes, 0, 20, ++off);
        bodyBytes[off += 21] = ByteUtils.intToByte(this.registeredDelivery);
        bodyBytes[++off] = ByteUtils.intToByte(this.msgLength);
        ++off;
        if (this.registeredDelivery == 1) {
            int off1 = 0;
            this.msgContent = new byte[this.msgLength];
            ByteUtils.bytesCopy(ByteUtils.longToBytes8(this.reportMsgId), this.msgContent, 0, 7, off1);
            ByteUtils.bytesCopy(this.reportStat.getBytes(), this.msgContent, 0, 6, off1 += 8);
            ByteUtils.bytesCopy(this.reportSubmitTime.getBytes(), this.msgContent, 0, 9, off1 += 7);
            ByteUtils.bytesCopy(this.reportDoneTime.getBytes(), this.msgContent, 0, 9, off1 += 10);
            ByteUtils.bytesCopy(this.reportDestTerminalId.getBytes(), this.msgContent, 0, 20, off1 += 10);
            ByteUtils.bytesCopy(ByteUtils.intToBytes4(this.reportSMSCSequence), this.msgContent, 0, 3, off1 += 21);
            off1 += 4;
        }
        ByteUtils.bytesCopy(this.msgContent, bodyBytes, 0, this.msgLength - 1, off);
        ByteUtils.bytesCopy(this.reserved.getBytes(), bodyBytes, 0, 7, off += this.msgLength);
        off += 8;
        return bodyBytes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPDeliverMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("msgId=" + this.msgId + ",");
        sb.append("destId=" + this.destId + ",");
        sb.append("serviceId=" + this.serviceId + ",");
        sb.append("tpPid=" + this.tpPid + ",");
        sb.append("tpUdhi=" + this.tpUdhi + ",");
        sb.append("msgFmt=" + this.msgFmt + ",");
        sb.append("srcTerminalId=" + this.srcTerminalId + ",");
        sb.append("registeredDelivery=" + this.registeredDelivery + ",");
        sb.append("msgLength=" + this.msgLength + ",");
        sb.append("msgContent=" + this.msgContent + ",");
        sb.append("reserved=" + this.reserved + "]");
        return sb.toString();
    }
}

