/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp.message;

import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.ByteUtils;

public class CMPPCancelMessage
extends CMPPBaseMessage {
    private long msgId;

    public CMPPCancelMessage() {
        super(7, 8);
    }

    @Override
    protected void setBody(byte[] bodyBytes) throws Exception {
        this.msgId = ByteUtils.Bytes8ToLong(bodyBytes);
        super.setBody(bodyBytes);
    }

    @Override
    protected byte[] getBody() throws Exception {
        byte[] bodyBytes = new byte[this.getCommandLength()];
        int offset = 0;
        ByteUtils.bytesCopy(ByteUtils.longToBytes8(this.msgId), bodyBytes, 0, 7, offset);
        offset += 8;
        return bodyBytes;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPPCancelMessage:[sequenceId=" + this.sequenceString() + ",");
        sb.append("msgId=" + this.msgId + "]");
        return sb.toString();
    }
}

