/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.sms.core.protocol.cmpp;

import cn.chenzw.sms.core.Callback;
import cn.chenzw.sms.core.Message;
import cn.chenzw.sms.core.Session;
import cn.chenzw.sms.core.protocol.cmpp.CMPPConnection;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPActiveTestMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPActiveTestRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPBaseMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPConnectMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPConnectRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPDeliverMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPDeliverRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPSubmitMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPSubmitRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPTerminateMessage;
import cn.chenzw.sms.core.protocol.cmpp.message.CMPPTerminateRespMessage;
import cn.chenzw.sms.core.protocol.cmpp.util.SequenceGenerator;
import cn.chenzw.sms.core.support.callback.ConnectionCallback;
import cn.chenzw.sms.core.support.callback.SubmitCallback;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPPSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(CMPPSession.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMddHHmmss");
    private CMPPConnection connection;
    private String sessionId;
    private boolean authenticated;
    private Object lock = new Object();
    private List<Callback> callbacks;
    private Map<Integer, Object> extIdCache;

    public CMPPSession(CMPPConnection connection, boolean authenticated) {
        this.connection = connection;
        this.sessionId = UUID.randomUUID().toString();
        this.authenticated = authenticated;
        this.callbacks = new ArrayList<Callback>();
        this.extIdCache = new HashMap<Integer, Object>();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void submit(String content, String spNumber, String userNumber) {
        this.submit(null, content, spNumber, userNumber);
    }

    @Override
    public void submit(Object extId, String content, String spNumber, String userNumber) {
        CMPPSubmitMessage submit = new CMPPSubmitMessage();
        submit.setServiceId("ACORN");
        submit.setAtTime("");
        submit.setSrcId(spNumber);
        submit.setMsgSrc(this.connection.getSourceAddr());
        submit.setFeeType("01");
        submit.setMsgText("\u4f60\u597d", 15);
        submit.addDestTerminalId(userNumber);
        submit.setSequenceId(SequenceGenerator.nextSequence());
        submit.setExtId(extId);
        this.addExtIdCache(submit);
        this.send(submit);
    }

    @Override
    public void heartbeat() {
        if (this.isAuthenticated()) {
            CMPPActiveTestMessage activeTest = new CMPPActiveTestMessage();
            activeTest.setSequenceId(SequenceGenerator.nextSequence());
            this.send(activeTest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate() {
        CMPPConnectMessage loginMsg = new CMPPConnectMessage();
        loginMsg.setSourceAddr(this.connection.getSourceAddr());
        loginMsg.setVersion(this.connection.getVersion());
        String tmp = dateFormat.format(Calendar.getInstance().getTime());
        loginMsg.setTimestamp(Integer.parseInt(tmp));
        loginMsg.setSharedSecret(this.connection.getPassword());
        loginMsg.setSequenceId(SequenceGenerator.nextSequence());
        this.send(loginMsg);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException ex) {
                this.setAuthenticated(false);
            }
        }
        return this.isAuthenticated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isAuthenticated()) {
            CMPPTerminateMessage exit = new CMPPTerminateMessage();
            exit.setSequenceId(SequenceGenerator.nextSequence());
            this.send(exit);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(6000L);
                }
                catch (InterruptedException ex) {
                    this.setAuthenticated(false);
                }
            }
        }
        this.connection.close();
    }

    @Override
    public void send(Message message) {
        this.connection.send(message);
    }

    @Override
    public void process(Message message) throws IOException {
        if (message instanceof CMPPBaseMessage) {
            CMPPBaseMessage baseMsg = (CMPPBaseMessage)message;
            baseMsg.setExtId(this.getExtIdFromCache(baseMsg));
            if (this.isAuthenticated()) {
                if (baseMsg instanceof CMPPActiveTestMessage) {
                    this.process((CMPPActiveTestMessage)baseMsg);
                } else if (baseMsg instanceof CMPPActiveTestRespMessage) {
                    this.process(baseMsg);
                } else if (baseMsg instanceof CMPPTerminateRespMessage) {
                    this.process((CMPPTerminateRespMessage)baseMsg);
                } else if (message instanceof CMPPSubmitRespMessage) {
                    this.process((CMPPSubmitRespMessage)message);
                } else if (message instanceof CMPPDeliverMessage) {
                    this.process((CMPPDeliverMessage)message);
                }
            } else if (baseMsg instanceof CMPPConnectRespMessage) {
                this.process((CMPPConnectRespMessage)baseMsg);
            } else {
                throw new IOException("the first packet was not CMPPBindRespMessage:" + baseMsg);
            }
        }
    }

    @Override
    public void registerCallbackHandler(Callback callback) {
        this.callbacks.add(callback);
    }

    private void process(CMPPActiveTestMessage msg) throws IOException {
        CMPPActiveTestRespMessage resp = new CMPPActiveTestRespMessage();
        resp.setSequenceId(msg.getSequenceId());
        this.send(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(CMPPConnectRespMessage rsp) throws IOException {
        List<Callback> globalCallbacks = this.connection.getRegistedCallbackHandler();
        Object object = this.lock;
        synchronized (object) {
            if (rsp.getStatus() == 0) {
                this.setAuthenticated(true);
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)globalCallback).onLoginSuccess(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)callback).onLoginSuccess(this.connection, rsp);
                }
                log.debug("cmpp login success host={},port={},sourceAddr={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getSourceAddr()});
            } else {
                this.setAuthenticated(false);
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)globalCallback).onLoingFailure(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof ConnectionCallback)) continue;
                    ((ConnectionCallback)callback).onLoingFailure(this.connection, rsp);
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                log.error("cmpp login failure, host={},port={},sourceAddr={} ,status={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getSourceAddr(), rsp.getStatus()});
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(CMPPTerminateRespMessage msg) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.setAuthenticated(false);
            this.lock.notifyAll();
        }
        log.debug("cmpp exist success host={},port={},sourceAddr={}", new Object[]{this.connection.getHost(), this.connection.getPort(), this.connection.getSourceAddr()});
    }

    private void process(CMPPSubmitRespMessage rsp) throws IOException {
        List<Callback> globalCallbacks = this.connection.getRegistedCallbackHandler();
        switch (rsp.getResult()) {
            case 0: {
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)globalCallback).onSendSuccess(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)callback).onSendSuccess(this.connection, rsp);
                }
                break;
            }
            default: {
                for (Callback globalCallback : globalCallbacks) {
                    if (!(globalCallback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)globalCallback).onSendFailure(this.connection, rsp);
                }
                for (Callback callback : this.callbacks) {
                    if (!(callback instanceof SubmitCallback)) continue;
                    ((SubmitCallback)callback).onSendFailure(this.connection, rsp);
                }
            }
        }
    }

    private void process(CMPPDeliverMessage msg) throws IOException {
        CMPPDeliverRespMessage rsp = new CMPPDeliverRespMessage();
        rsp.setSequenceId(msg.getSequenceId());
        rsp.setMsgId(msg.getMsgId());
        rsp.setResult(0);
        this.send(rsp);
    }

    private void setAuthenticated(boolean value) {
        this.authenticated = value;
    }

    private void addExtIdCache(CMPPSubmitMessage submitMessage) {
        this.extIdCache.put(submitMessage.getSequenceId(), submitMessage.getExtId());
    }

    private Object getExtIdFromCache(CMPPBaseMessage baseMsg) {
        return this.extIdCache.get(baseMsg.getSequenceId());
    }
}

