/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.ws.util;

import cn.chenzw.toolkit.ws.exception.SoapException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class SoapUtils {
    private static final String SOAP_BODY_XPATH = "/Envelope/*[local-name()='Body']";
    private static final String SOAP_CHILD_XPATH = "*/*";

    public static String toString(SOAPMessage message, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
            return out.toString(charset.toString());
        }
        catch (IOException | SOAPException e) {
            throw new SoapException("SOAPMessage fail to transform to string.", e);
        }
    }

    public static Node getContentNode(String soapResponse) {
        Node bodyNode;
        if (StringUtils.isEmpty(soapResponse)) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read((Reader)new StringReader(soapResponse));
        }
        catch (DocumentException e) {
            throw new SoapException("Parse soap response with error:[" + soapResponse + "].", e);
        }
        Element root = doc.getRootElement();
        if (root != null && (bodyNode = root.selectSingleNode(SOAP_BODY_XPATH)) != null) {
            return bodyNode.selectSingleNode(SOAP_CHILD_XPATH);
        }
        return null;
    }

    public static String getContent(String soapResponse) {
        Node contentNode = SoapUtils.getContentNode(soapResponse);
        if (contentNode != null) {
            return contentNode.asXML();
        }
        return null;
    }

    public static <T> T parse(String soapResponse) {
        SoapUtils.getContent(soapResponse);
        return null;
    }
}

