/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.ws;

import cn.chenzw.toolkit.ws.constants.SoapProtocol;
import cn.chenzw.toolkit.ws.exception.SoapException;
import cn.chenzw.toolkit.ws.parts.SoapBody;
import cn.chenzw.toolkit.ws.parts.SoapHeader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SoapRequest
implements Cloneable {
    private String url;
    private Charset charset = StandardCharsets.UTF_8;
    private SOAPMessage message;
    private SoapProtocol soapProtocol;

    public String getUrl() {
        return this.url;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    private SoapRequest(Builder builder) {
        if (StringUtils.isEmpty(builder.url)) {
            throw new IllegalArgumentException("Parameter `url` is empty!");
        }
        this.url = builder.url;
        this.soapProtocol = builder.soapProtocol;
        if (builder.charset != null) {
            this.charset = builder.charset;
        }
        try {
            MessageFactory factory = MessageFactory.newInstance((String)this.soapProtocol.getValue());
            this.message = factory.createMessage();
            this.initSoapHeader(this.message, builder.soapHeader);
            this.initSoapBody(this.message, builder.soapBody);
            this.message.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charset.toString());
            this.message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (SOAPException e) {
            throw new SoapException("Initialize SOAPMessage width error.", e);
        }
    }

    private void initSoapHeader(SOAPMessage message, SoapHeader soapHeader) throws SOAPException {
        SOAPHeader soapHeaderEntity = message.getSOAPHeader();
        if (soapHeader != null) {
            List<SOAPElement> soapHeaderElements = soapHeader.getSoapHeaderElements();
            for (SOAPElement soapHeaderElement : soapHeaderElements) {
                soapHeaderEntity.addChildElement(soapHeaderElement);
            }
        }
    }

    private void initSoapBody(SOAPMessage message, SoapBody soapBody) throws SOAPException {
        if (soapBody != null) {
            SOAPBodyElement soapBodyElement;
            if (StringUtils.contains((CharSequence)soapBody.getMethodName(), ":")) {
                String[] methodNames = StringUtils.split(soapBody.getMethodName(), ":");
                soapBodyElement = message.getSOAPBody().addBodyElement(new QName(ObjectUtils.defaultIfNull(soapBody.getNamespaceURI(), ""), methodNames[1], methodNames[0]));
            } else {
                soapBodyElement = message.getSOAPBody().addBodyElement(new QName(ObjectUtils.defaultIfNull(soapBody.getNamespaceURI(), ""), soapBody.getMethodName()));
            }
            Map<String, Object> params = soapBody.getParams();
            for (Map.Entry<String, Object> paramsEntry : params.entrySet()) {
                this.addParam((SOAPElement)soapBodyElement, paramsEntry.getKey(), paramsEntry.getValue(), soapBody.getUseMethodPrefix());
            }
        }
    }

    private void addParam(SOAPElement soapBodyElement, String name, Object value, Boolean useMethodPrefix) throws SOAPException {
        String prefix = useMethodPrefix != null && useMethodPrefix != false ? soapBodyElement.getPrefix() : "";
        SOAPElement childElement = StringUtils.isNotEmpty(prefix) ? soapBodyElement.addChildElement(name, prefix) : soapBodyElement.addChildElement(name);
        if (value != null) {
            if (value instanceof SOAPElement) {
                soapBodyElement.addChildElement((SOAPElement)value);
            } else if (value instanceof Map) {
                Map childParams = (Map)value;
                for (Map.Entry childParamsEntry : childParams.entrySet()) {
                    this.addParam(childElement, (String)childParamsEntry.getKey(), childParamsEntry.getValue(), useMethodPrefix);
                }
            } else {
                childElement.setValue(value.toString());
            }
        }
    }

    public static Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private String url;
        private Charset charset;
        private SoapHeader soapHeader;
        private SoapBody soapBody;
        private SoapProtocol soapProtocol;

        public Builder() {
            this.soapProtocol = SoapProtocol.SOAP_1_1;
        }

        Builder(SoapRequest soapRequest) {
            this.url = soapRequest.url;
            this.charset = soapRequest.charset;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder header(SoapHeader soapHeader) {
            this.soapHeader = soapHeader;
            return this;
        }

        public Builder body(SoapBody soapBody) {
            this.soapBody = soapBody;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder protocol(SoapProtocol soapProtocol) {
            this.soapProtocol = soapProtocol;
            return this;
        }

        public SoapRequest build() {
            return new SoapRequest(this);
        }
    }
}

