/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.ws;

import cn.chenzw.toolkit.ws.SoapRequest;
import cn.chenzw.toolkit.ws.util.SoapUtils;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.InternalCache;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;

public class SoapOkHttpClient {
    private static final String MEDIA_TYPE_XML = "text/xml;charset=";
    private final OkHttpClient okHttpClient;

    public Call newCall(SoapRequest soapRequest) {
        MediaType mediaType = MediaType.parse((String)(MEDIA_TYPE_XML + soapRequest.getCharset().name()));
        return this.okHttpClient.newCall(new Request.Builder().url(soapRequest.getUrl()).post(RequestBody.create((MediaType)mediaType, (String)SoapUtils.toString(soapRequest.getMessage(), soapRequest.getCharset()))).build());
    }

    public static Builder create() {
        return new Builder();
    }

    private SoapOkHttpClient(Builder builder) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().dispatcher(builder.dispatcher).proxy(builder.proxy);
        if (builder.protocols != null) {
            okHttpClientBuilder.protocols(builder.protocols);
        }
        if (builder.connectionSpecs != null) {
            okHttpClientBuilder.connectionSpecs(builder.connectionSpecs);
        }
        okHttpClientBuilder.proxySelector(builder.proxySelector).cookieJar(builder.cookieJar).cache(builder.cache).socketFactory(builder.socketFactory).hostnameVerifier(builder.hostnameVerifier).proxyAuthenticator(builder.proxyAuthenticator).authenticator(builder.authenticator).connectionPool(builder.connectionPool).dns(builder.dns).followRedirects(builder.followRedirects).followSslRedirects(builder.followSslRedirects).retryOnConnectionFailure(builder.retryOnConnectionFailure).connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS);
        for (Interceptor interceptor : builder.interceptors) {
            okHttpClientBuilder.addInterceptor(interceptor);
        }
        for (Interceptor networkInterceptor : builder.networkInterceptors) {
            okHttpClientBuilder.addNetworkInterceptor(networkInterceptor);
        }
        this.okHttpClient = okHttpClientBuilder.build();
    }

    public static final class Builder {
        Dispatcher dispatcher;
        Proxy proxy;
        List<Protocol> protocols;
        List<ConnectionSpec> connectionSpecs;
        final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        final List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
        ProxySelector proxySelector;
        CookieJar cookieJar;
        Cache cache;
        InternalCache internalCache;
        SocketFactory socketFactory;
        SSLSocketFactory sslSocketFactory;
        CertificateChainCleaner certificateChainCleaner;
        HostnameVerifier hostnameVerifier;
        Authenticator proxyAuthenticator;
        Authenticator authenticator;
        ConnectionPool connectionPool;
        Dns dns;
        boolean followSslRedirects = true;
        boolean followRedirects = true;
        boolean retryOnConnectionFailure = true;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;

        public Builder() {
            this.dispatcher = new Dispatcher();
            this.proxySelector = ProxySelector.getDefault();
            this.cookieJar = CookieJar.NO_COOKIES;
            this.socketFactory = SocketFactory.getDefault();
            this.hostnameVerifier = OkHostnameVerifier.INSTANCE;
            this.proxyAuthenticator = Authenticator.NONE;
            this.authenticator = Authenticator.NONE;
            this.connectionPool = new ConnectionPool();
            this.dns = Dns.SYSTEM;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout < 0");
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            long millis = unit.toMillis(timeout);
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout too large.");
            }
            if (millis == 0L && timeout > 0L) {
                throw new IllegalArgumentException("Timeout too small.");
            }
            this.connectTimeout = (int)millis;
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout < 0");
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            long millis = unit.toMillis(timeout);
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout too large.");
            }
            if (millis == 0L && timeout > 0L) {
                throw new IllegalArgumentException("Timeout too small.");
            }
            this.readTimeout = (int)millis;
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout < 0");
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            long millis = unit.toMillis(timeout);
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout too large.");
            }
            if (millis == 0L && timeout > 0L) {
                throw new IllegalArgumentException("Timeout too small.");
            }
            this.writeTimeout = (int)millis;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxySelector(ProxySelector proxySelector) {
            this.proxySelector = proxySelector;
            return this;
        }

        public Builder cookieJar(CookieJar cookieJar) {
            if (cookieJar == null) {
                throw new NullPointerException("cookieJar == null");
            }
            this.cookieJar = cookieJar;
            return this;
        }

        void setInternalCache(InternalCache internalCache) {
            this.internalCache = internalCache;
            this.cache = null;
        }

        public Builder cache(Cache cache) {
            this.cache = cache;
            this.internalCache = null;
            return this;
        }

        public Builder dns(Dns dns) {
            if (dns == null) {
                throw new NullPointerException("dns == null");
            }
            this.dns = dns;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new NullPointerException("socketFactory == null");
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            if (sslSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory == null");
            }
            this.sslSocketFactory = sslSocketFactory;
            this.certificateChainCleaner = Platform.get().buildCertificateChainCleaner(sslSocketFactory);
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            if (sslSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory == null");
            }
            if (trustManager == null) {
                throw new NullPointerException("trustManager == null");
            }
            this.sslSocketFactory = sslSocketFactory;
            this.certificateChainCleaner = CertificateChainCleaner.get((X509TrustManager)trustManager);
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new NullPointerException("hostnameVerifier == null");
            }
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder authenticator(Authenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException("authenticator == null");
            }
            this.authenticator = authenticator;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            if (proxyAuthenticator == null) {
                throw new NullPointerException("proxyAuthenticator == null");
            }
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            if (connectionPool == null) {
                throw new NullPointerException("connectionPool == null");
            }
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder followSslRedirects(boolean followProtocolRedirects) {
            this.followSslRedirects = followProtocolRedirects;
            return this;
        }

        public Builder followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder dispatcher(Dispatcher dispatcher) {
            if (dispatcher == null) {
                throw new IllegalArgumentException("dispatcher == null");
            }
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder protocols(List<Protocol> protocols) {
            if (!(protocols = Util.immutableList(protocols)).contains(Protocol.HTTP_1_1)) {
                throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
            }
            if (protocols.contains(Protocol.HTTP_1_0)) {
                throw new IllegalArgumentException("protocols must not contain http/1.0: " + protocols);
            }
            if (protocols.contains(null)) {
                throw new IllegalArgumentException("protocols must not contain null");
            }
            this.protocols = Util.immutableList((List)protocols);
            return this;
        }

        public Builder connectionSpecs(List<ConnectionSpec> connectionSpecs) {
            this.connectionSpecs = Util.immutableList(connectionSpecs);
            return this;
        }

        public List<Interceptor> interceptors() {
            return this.interceptors;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public List<Interceptor> networkInterceptors() {
            return this.networkInterceptors;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public SoapOkHttpClient build() {
            return new SoapOkHttpClient(this);
        }
    }
}

