/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.validation.exception;

import cn.chenzw.toolkit.commons.StringExtUtils;
import cn.chenzw.toolkit.http.HttpRequestWrapper;
import cn.chenzw.toolkit.validation.exception.ConstraintViolationExceptionWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class DefaultConstraintViolationExceptionWrapper
implements ConstraintViolationExceptionWrapper {
    private List<ConstraintViolationExceptionWrapper.InvalidField> invalidFields = new ArrayList<ConstraintViolationExceptionWrapper.InvalidField>();
    private String methodName;
    private Class<?> beanClass;
    private HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper();

    public DefaultConstraintViolationExceptionWrapper(ConstraintViolationException constraintViolationException) {
        for (ConstraintViolation cv : constraintViolationException.getConstraintViolations()) {
            String fieldName = StringExtUtils.subStringFirstAfter(cv.getPropertyPath().toString(), ".");
            this.invalidFields.add(new ConstraintViolationExceptionWrapper.InvalidField(fieldName, cv.getMessage(), cv.getInvalidValue(), cv.getMessageTemplate()));
            this.beanClass = cv.getRootBeanClass();
            this.methodName = StringExtUtils.subStringFirstBefore(cv.getPropertyPath().toString(), ".");
        }
    }

    public DefaultConstraintViolationExceptionWrapper(MethodArgumentNotValidException methodArgumentNotValidException) {
        List fieldErrors = methodArgumentNotValidException.getBindingResult().getFieldErrors();
        for (FieldError fieldError : fieldErrors) {
            this.invalidFields.add(new ConstraintViolationExceptionWrapper.InvalidField(fieldError.getField(), fieldError.getDefaultMessage(), fieldError.getRejectedValue(), fieldError.getDefaultMessage()));
        }
        this.beanClass = methodArgumentNotValidException.getParameter().getContainingClass();
        this.methodName = methodArgumentNotValidException.getParameter().getMethod().getName();
    }

    public DefaultConstraintViolationExceptionWrapper(BindException bindException) {
        List fieldErrors = bindException.getBindingResult().getFieldErrors();
        for (FieldError fieldError : fieldErrors) {
            this.invalidFields.add(new ConstraintViolationExceptionWrapper.InvalidField(fieldError.getField(), fieldError.getDefaultMessage(), fieldError.getRejectedValue(), fieldError.getDefaultMessage()));
        }
    }

    @Override
    public List<ConstraintViolationExceptionWrapper.InvalidField> getInvalidFields() {
        return this.invalidFields;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public HttpRequestWrapper getHttpRequestWrapper() {
        return this.httpRequestWrapper;
    }

    @Override
    public String toHumanString() {
        StringBuilder msgBuilder = new StringBuilder();
        for (ConstraintViolationExceptionWrapper.InvalidField invalidField : this.invalidFields) {
            msgBuilder.append(String.format("\u53c2\u6570[%s = %s]\u6821\u9a8c\u4e0d\u901a\u8fc7:[%s]; ", invalidField.getFieldName(), invalidField.getInvalidValue(), invalidField.getMessage()));
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return "DefaultConstraintViolationExceptionWrapper{invalidFields=" + this.invalidFields + ", methodName='" + this.methodName + '\'' + ", beanClass=" + this.beanClass + ", httpRequestWrapper=" + this.httpRequestWrapper + '}';
    }
}

