/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.spring.util;

import cn.chenzw.toolkit.commons.ClassExtUtils;
import cn.chenzw.toolkit.spring.core.SpringContextHolder;
import cn.chenzw.toolkit.spring.domain.ContextBeans;
import cn.chenzw.toolkit.spring.domain.ContextFilterMappings;
import cn.chenzw.toolkit.spring.domain.ContextHandlerMappings;
import cn.chenzw.toolkit.spring.domain.ContextServletMappings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public final class SpringUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringUtils.class);
    public static final boolean SPRING_FREMAE_PRESENT = ClassExtUtils.isPresent("org.springframework.context.ApplicationContext");
    public static final boolean SPRING_WEB_FRAME_PRESENT = ClassExtUtils.isPresent("org.springframework.web.servlet.DispatcherServlet");

    private SpringUtils() {
    }

    public static ApplicationContext getAppContext() {
        return SpringContextHolder.getAppContext();
    }

    public static Object getBean(String name) {
        return SpringUtils.getAppContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtils.getAppContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtils.getAppContext().getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return SpringUtils.getAppContext().getBeansOfType(clazz);
    }

    public static ContextBeans getBeans() {
        return ContextBeans.describing((ConfigurableApplicationContext)SpringUtils.getAppContext());
    }

    public static <T> T registerBean(String name, Class<T> clazz, Object ... args) {
        return SpringUtils.doRegisterBean(name, clazz, args);
    }

    public static <T> T registerBean(Class<T> clazz, Object ... args) {
        return SpringUtils.registerBean(null, clazz, args);
    }

    public static void registerController(RequestMappingInfo requestMappingInfo, Object handler, Method method) throws NoSuchMethodException {
        RequestMappingHandlerMapping requestMappingHandlerMapping = SpringUtils.getBean(RequestMappingHandlerMapping.class);
        requestMappingHandlerMapping.registerMapping((Object)requestMappingInfo, handler, method);
    }

    public static String getContextPath() {
        return SpringUtils.getAppContext().getEnvironment().getProperty("server.context-path");
    }

    public static String getPort() {
        return SpringUtils.getAppContext().getEnvironment().getProperty("server.port");
    }

    private static <T> T doRegisterBean(String beanName, Class<T> clazz, Object ... args) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (ArrayUtils.isNotEmpty(args)) {
            for (Object arg : args) {
                beanDefinitionBuilder.addConstructorArgValue(arg);
            }
        }
        ApplicationContext appContext = SpringUtils.getAppContext();
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)((ConfigurableApplicationContext)appContext).getBeanFactory();
        if (StringUtils.isBlank(beanName)) {
            beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)beanFactory, (boolean)false);
        }
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return (T)appContext.getBean(beanName, clazz);
    }

    public static ContextHandlerMappings getHandlerMappings() {
        ApplicationContext appContext = SpringUtils.getAppContext();
        ArrayList<ContextHandlerMappings.HandlerMappingDescription> handlerMappingDescriptions = new ArrayList<ContextHandlerMappings.HandlerMappingDescription>();
        Map handerMappings = appContext.getBeansOfType(HandlerMapping.class);
        for (Map.Entry handlerMappingEntity : handerMappings.entrySet()) {
            HandlerMapping handlerMapping = (HandlerMapping)handlerMappingEntity.getValue();
            if (handlerMapping instanceof RequestMappingHandlerMapping) {
                RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)handlerMapping;
                Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
                for (Map.Entry handlerMethodEntry : handlerMethods.entrySet()) {
                    handlerMappingDescriptions.add(new ContextHandlerMappings.HandlerMappingDescription(((HandlerMethod)handlerMethodEntry.getValue()).toString(), ((RequestMappingInfo)handlerMethodEntry.getKey()).toString(), new ContextHandlerMappings.HandlerMethodDescription((HandlerMethod)handlerMethodEntry.getValue()), new ContextHandlerMappings.RequestMappingConditionsDescription((RequestMappingInfo)handlerMethodEntry.getKey())));
                }
                continue;
            }
            if (handlerMapping instanceof BeanNameUrlHandlerMapping) {
                BeanNameUrlHandlerMapping beanNameUrlHandlerMapping = (BeanNameUrlHandlerMapping)handlerMapping;
                Map handlerMap = beanNameUrlHandlerMapping.getHandlerMap();
                logger.info("BeanNameUrlHandlerMapping: {}", (Object)handlerMap);
                continue;
            }
            if (handlerMapping instanceof SimpleUrlHandlerMapping) {
                SimpleUrlHandlerMapping simpleUrlHandlerMapping = (SimpleUrlHandlerMapping)handlerMapping;
                Map urlMap = simpleUrlHandlerMapping.getUrlMap();
                for (Map.Entry urlMappingEntry : urlMap.entrySet()) {
                    if (urlMappingEntry.getValue() instanceof ResourceHttpRequestHandler) {
                        ResourceHttpRequestHandler resourceHttpRequestHandler = (ResourceHttpRequestHandler)urlMappingEntry.getValue();
                        handlerMappingDescriptions.add(new ContextHandlerMappings.HandlerMappingDescription(urlMappingEntry.getValue().toString(), (String)urlMappingEntry.getKey(), new ContextHandlerMappings.HandlerMethodDescription(resourceHttpRequestHandler.getClass().getName(), resourceHttpRequestHandler.getClass().getSimpleName(), null), new ContextHandlerMappings.RequestMappingConditionsDescription(null, null, Collections.singleton(RequestMethod.GET), null, Collections.singleton(urlMappingEntry.getKey()), null)));
                        continue;
                    }
                    logger.info("Extended HttpRequestHandler: {}", (Object)urlMappingEntry);
                }
                continue;
            }
            logger.info("Extended HandlerMapping: {}", (Object)handlerMapping);
        }
        return new ContextHandlerMappings(handlerMappingDescriptions, appContext.getId());
    }

    public static ContextFilterMappings getFilterMappings() {
        ApplicationContext appContext = SpringUtils.getAppContext();
        ArrayList<ContextFilterMappings.FilterRegistrationMappingDescription> mappings = new ArrayList<ContextFilterMappings.FilterRegistrationMappingDescription>();
        if (appContext instanceof WebApplicationContext) {
            Collection<? extends FilterRegistration> filterRegistrations = ((WebApplicationContext)appContext).getServletContext().getFilterRegistrations().values();
            for (FilterRegistration filterRegistration : filterRegistrations) {
                mappings.add(new ContextFilterMappings.FilterRegistrationMappingDescription(filterRegistration));
            }
        }
        return new ContextFilterMappings(mappings, appContext.getId());
    }

    public static ContextServletMappings getServletMappings() {
        ArrayList<ContextServletMappings.ServletRegistrationMappingDescription> mappings = new ArrayList<ContextServletMappings.ServletRegistrationMappingDescription>();
        ApplicationContext appContext = SpringUtils.getAppContext();
        if (appContext instanceof WebApplicationContext) {
            Collection<? extends ServletRegistration> servletRegistrations = ((WebApplicationContext)appContext).getServletContext().getServletRegistrations().values();
            for (ServletRegistration servletRegistration : servletRegistrations) {
                mappings.add(new ContextServletMappings.ServletRegistrationMappingDescription(servletRegistration));
            }
        }
        return new ContextServletMappings(mappings, appContext.getId());
    }

    public static HandlerMethod getHanlerMethod(HttpServletRequest request) throws Exception {
        Map<String, HandlerMapping> handlerMappingMap = SpringUtils.getBeansOfType(HandlerMapping.class);
        for (HandlerMapping handlerMapping : handlerMappingMap.values()) {
            Object handler;
            HandlerExecutionChain handlerExecutionChain = handlerMapping.getHandler(request);
            if (handlerExecutionChain == null || !((handler = handlerExecutionChain.getHandler()) instanceof HandlerMethod)) continue;
            return (HandlerMethod)handler;
        }
        return null;
    }
}

