/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.spring.util;

import cn.chenzw.toolkit.spring.core.SpringContextHolder;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static <T> T get(ApplicationContext applicationContext, String propertyName, Class<T> returnType) {
        Binder binder = Binder.get((Environment)applicationContext.getEnvironment());
        return (T)binder.bind(propertyName, returnType).get();
    }

    public static <T> T get(String propertyName, Class<T> returnType) {
        ApplicationContext appContext = SpringContextHolder.getAppContext();
        if (appContext == null) {
            throw new NullPointerException("ApplicationContext is null! you can add @EnableTookit to @Configuration!");
        }
        return PropertyUtils.get(appContext, propertyName, returnType);
    }
}

