/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.spring.ratelimit.aop;

import cn.chenzw.toolkit.spring.aop.JoinPointWrapper;
import cn.chenzw.toolkit.spring.ratelimit.annotation.MethodRateLimit;
import cn.chenzw.toolkit.spring.ratelimit.exception.RateLimitException;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class MethodRateLimitAspect {
    private final Map<String, RateLimiter> rateLimiters = new ConcurrentHashMap<String, RateLimiter>();

    @Pointcut(value="@annotation(cn.chenzw.toolkit.spring.ratelimit.annotation.MethodRateLimit)")
    public void methodRateLimit() {
    }

    @Before(value="methodRateLimit()")
    public void before(JoinPoint joinPoint) {
        JoinPointWrapper joinPointWrapper = new JoinPointWrapper(joinPoint);
        String rateLimitKey = this.getRateLimitKey(joinPointWrapper);
        MethodRateLimit methodRateLimit = joinPointWrapper.getAnnotation(MethodRateLimit.class);
        RateLimiter rateLimiter = this.rateLimiters.get(rateLimitKey);
        if (rateLimiter == null) {
            rateLimiter = RateLimiter.create((double)methodRateLimit.permits(), (long)methodRateLimit.period(), (TimeUnit)methodRateLimit.unit());
            this.rateLimiters.putIfAbsent(rateLimitKey, rateLimiter);
        }
        if (!rateLimiter.tryAcquire()) {
            throw new RateLimitException("Request rate exceeds limit");
        }
    }

    private String getRateLimitKey(JoinPointWrapper joinPointWrapper) {
        MethodSignature methodSignature = (MethodSignature)joinPointWrapper.getJoinPoint().getSignature();
        return joinPointWrapper.getCanonicalClassMethod() + "." + joinPointWrapper.getMethodName() + Arrays.toString(methodSignature.getParameterTypes());
    }
}

