/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.spring.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

@Component
public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext appContext;
    private static Map<String, ApplicationContext> appContexts;

    public static void addContext(ApplicationContext applicationContext) {
        appContexts.putIfAbsent(applicationContext.getId(), applicationContext);
    }

    public static void removeContext(ApplicationContext applicationContext) {
        appContexts.remove(applicationContext.getId());
    }

    public static Map<String, ApplicationContext> getAllAppContexts() {
        return appContexts;
    }

    public static ApplicationContext getAppContext() {
        if (appContext == null) {
            appContext = ContextLoader.getCurrentWebApplicationContext();
        }
        return appContext;
    }

    public static void clear() {
        appContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        appContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clear();
    }

    static {
        appContexts = new ConcurrentHashMap<String, ApplicationContext>();
    }
}

