/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.spring.aop;

import cn.chenzw.toolkit.http.HttpHolder;
import cn.chenzw.toolkit.http.HttpRequestWrapper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class JoinPointWrapper {
    private JoinPoint joinPoint;
    private HttpRequestWrapper requestWrapper;

    public JoinPointWrapper(JoinPoint joinPoint) {
        this.joinPoint = joinPoint;
        this.requestWrapper = new HttpRequestWrapper(HttpHolder.getRequest());
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        MethodSignature methodSignature = (MethodSignature)this.joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (method.isAnnotationPresent(annotationClass)) {
            return method.getAnnotation(annotationClass);
        }
        return null;
    }

    public String getURI() {
        return this.requestWrapper.getURI();
    }

    public String getHttpMethod() {
        return this.requestWrapper.getMethod();
    }

    public String getQueryString() {
        return this.requestWrapper.getQueryString();
    }

    public String getClientIp() {
        return this.requestWrapper.getClientIp();
    }

    public long getThreadId() {
        return this.requestWrapper.getThreadId();
    }

    public String getThreadName() {
        return this.requestWrapper.getThreadName();
    }

    public String getClassName() {
        return this.joinPoint.getSignature().getDeclaringTypeName();
    }

    public String getMethodName() {
        return this.joinPoint.getSignature().getName();
    }

    public String getCanonicalClassMethod() {
        return this.getClassName() + "." + this.getMethodName();
    }

    public ParamMeta[] getMethodArgs() {
        MethodSignature methodSignature = (MethodSignature)this.joinPoint.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        Class[] parameterTypes = methodSignature.getParameterTypes();
        ParamMeta[] paramMetas = new ParamMeta[parameterNames.length];
        Object[] args = this.joinPoint.getArgs();
        for (int i = 0; i < paramMetas.length; ++i) {
            ParamMeta paramMeta = new ParamMeta();
            paramMeta.setName(parameterNames[i]);
            paramMeta.setType(parameterTypes[i]);
            paramMeta.setValue(args[i]);
            paramMetas[i] = paramMeta;
        }
        return paramMetas;
    }

    public String getBodyString() throws IOException {
        return this.requestWrapper.getBodyString();
    }

    public String getArtifactId() {
        Package aPackage = this.joinPoint.getTarget().getClass().getPackage();
        return aPackage.getImplementationTitle();
    }

    public static class ParamMeta {
        private String name;
        private Class<?> type;
        private Object value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return "ParamMeta{name='" + this.name + '\'' + ", type=" + this.type + ", value='" + this.value + '\'' + '}';
        }
    }
}

