/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.mybatis.dynamic.util;

import cn.chenzw.toolkit.commons.ReflectExtUtils;
import cn.chenzw.toolkit.mybatis.dynamic.support.MybatisPropertiesHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class SqlMapperUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlMapperUtils.class);

    private SqlMapperUtils() {
    }

    public static <T> T getMapper(DataSource dataSource, Class<T> mapper) throws Exception {
        Configuration configuration;
        if (dataSource == null) {
            throw new IllegalArgumentException("Parameter dataSource is null");
        }
        MybatisProperties mybatisProperties = MybatisPropertiesHolder.getMybatisProperties();
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringUtils.hasText((String)mybatisProperties.getConfigLocation())) {
            factory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(mybatisProperties.getConfigLocation()));
        }
        if ((configuration = mybatisProperties.getConfiguration()) == null && !StringUtils.hasText((String)mybatisProperties.getConfigLocation())) {
            configuration = new Configuration();
        }
        factory.setConfiguration(configuration);
        if (mybatisProperties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(mybatisProperties.getConfigurationProperties());
        }
        if (StringUtils.hasLength((String)mybatisProperties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(mybatisProperties.getTypeAliasesPackage());
        }
        if (mybatisProperties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(mybatisProperties.getTypeAliasesSuperType());
        }
        if (StringUtils.hasLength((String)mybatisProperties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(mybatisProperties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])mybatisProperties.resolveMapperLocations())) {
            factory.setMapperLocations(mybatisProperties.resolveMapperLocations());
        }
        SqlSessionFactory sqlSessionFactory = factory.getObject();
        SqlSession session = sqlSessionFactory.openSession();
        Object mapper1 = session.getMapper(mapper);
        return (T)mapper1;
    }

    public static void closeMapper(Object mapper) {
        if (mapper == null) {
            throw new NullPointerException("Mapper is null!");
        }
        InvocationHandler proxy = Proxy.getInvocationHandler(mapper);
        if (!(proxy instanceof MapperProxy)) {
            throw new IllegalArgumentException("Mapper [" + mapper + "] not instanceof MapperProxy!");
        }
        try {
            SqlSession sqlSession = (SqlSession)ReflectExtUtils.getFieldValueQuietly((MapperProxy)proxy, "sqlSession");
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static <T extends Annotation> Optional<T> getProxyTargetAnnotation(Object target, Class<T> annotationClass) {
        InvocationHandler proxy;
        if (Proxy.isProxyClass(target.getClass()) && MapperProxy.class.isInstance(proxy = Proxy.getInvocationHandler(target))) {
            Object targetMapper = null;
            try {
                targetMapper = ReflectExtUtils.getFieldValueQuietly((MapperProxy)proxy, "mapperInterface");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (targetMapper != null && ((Class)targetMapper).isAnnotationPresent(annotationClass)) {
                return Optional.ofNullable(((Class)targetMapper).getAnnotation(annotationClass));
            }
        }
        return Optional.empty();
    }
}

