/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.mybatis.dynamic.support;

import cn.chenzw.toolkit.commons.MapExtUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DynamicDataSourceContext {
    private Map<String, DataSourceExtProperties> dataSourceMap = new ConcurrentHashMap<String, DataSourceExtProperties>();

    private DynamicDataSourceContext() {
    }

    public static DynamicDataSourceContext getInstance() {
        return InnerDataSourceContext.instance;
    }

    public void add(String dsName, DataSource dataSource) {
        this.dataSourceMap.put(dsName, new DataSourceExtProperties(dsName, dataSource));
    }

    public DataSource get(String dsName) {
        DataSourceExtProperties dataSourceExtProperties = this.dataSourceMap.get(dsName);
        if (dataSourceExtProperties != null) {
            return dataSourceExtProperties.getDataSource();
        }
        return null;
    }

    public DataSourceExtProperties getExt(String dsName) {
        return this.dataSourceMap.get(dsName);
    }

    private DataSourceExtProperties getPrimaryExt() {
        DataSourceExtProperties extProperties;
        Iterator<Map.Entry<String, DataSourceExtProperties>> iterator = this.dataSourceMap.entrySet().iterator();
        if (iterator.hasNext() && (extProperties = iterator.next().getValue()).isPrimary()) {
            return extProperties;
        }
        return this.dataSourceMap.getOrDefault("default.ds", (DataSourceExtProperties)MapExtUtils.getFirstValue(this.dataSourceMap));
    }

    public DataSource getPrimary() {
        return this.getPrimaryExt().getDataSource();
    }

    public String getPrimaryName() {
        return this.getPrimaryExt().getName();
    }

    public Map<String, DataSource> list() {
        HashMap<String, DataSource> results = new HashMap<String, DataSource>();
        for (Map.Entry<String, DataSourceExtProperties> extPropertiesEntry : this.dataSourceMap.entrySet()) {
            results.put(extPropertiesEntry.getKey(), extPropertiesEntry.getValue().getDataSource());
        }
        return results;
    }

    public Map<Object, Object> list2() {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        for (Map.Entry<String, DataSourceExtProperties> extPropertiesEntry : this.dataSourceMap.entrySet()) {
            results.put(extPropertiesEntry.getKey(), extPropertiesEntry.getValue().getDataSource());
        }
        return results;
    }

    public Map<String, DataSourceExtProperties> listExt() {
        return this.dataSourceMap;
    }

    public void add(String dsName, DataSource dataSource, boolean primary) {
        this.dataSourceMap.put(dsName, new DataSourceExtProperties(dsName, dataSource, primary));
    }

    public class DataSourceExtProperties {
        private String name;
        private boolean primary = false;
        private DataSource dataSource;

        public DataSourceExtProperties(String name, DataSource dataSource) {
            this.name = name;
            this.dataSource = dataSource;
        }

        public DataSourceExtProperties(String name, DataSource dataSource, boolean primary) {
            this.name = name;
            this.dataSource = dataSource;
            this.primary = primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "DataSourceExtProperties{name='" + this.name + '\'' + ", primary=" + this.primary + ", dataSource=" + this.dataSource + '}';
        }
    }

    private static class InnerDataSourceContext {
        private static DynamicDataSourceContext instance = new DynamicDataSourceContext();

        private InnerDataSourceContext() {
        }
    }
}

