/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.mybatis.dynamic.config;

import cn.chenzw.toolkit.commons.ConvertExtUtils;
import cn.chenzw.toolkit.commons.MapExtUtils;
import cn.chenzw.toolkit.commons.StringExtUtils;
import cn.chenzw.toolkit.mybatis.dynamic.aop.AnnotationDynamicDataSourceAspect;
import cn.chenzw.toolkit.mybatis.dynamic.support.DynamicDataSourceContext;
import cn.chenzw.toolkit.mybatis.dynamic.support.DynamicRoutingDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections4.map.TransformedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Order(value=-2147483648)
public class DynamicDataSourceConfig
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DYNAMIC_DATASOURCE_PROPERTY_PREFIX = "spring.datasource.dynamic";
    private static final String DEFAULT_DATASOURCE_PROPERTY_PREFIX = "spring.datasource";
    public static final String DEFAULT_DATASOURCE_NAME = "default.ds";

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource() {
        DynamicRoutingDataSource dynamicRoutingDataSource = new DynamicRoutingDataSource();
        DynamicDataSourceContext dynamicDataSourceContext = DynamicDataSourceContext.getInstance();
        DataSource primaryDataSource = dynamicDataSourceContext.getPrimary();
        this.logger.debug("Use primary datasource [{}]", (Object)dynamicDataSourceContext.getPrimaryName());
        dynamicRoutingDataSource.setDefaultTargetDataSource(primaryDataSource);
        dynamicRoutingDataSource.setTargetDataSources(dynamicDataSourceContext.list2());
        return dynamicRoutingDataSource;
    }

    private Map<String, Object> getPropertiesMap(Binder binder, String prefix) {
        try {
            return (Map)binder.bind(prefix, Map.class).get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private DruidDataSource createDruidDataSource(Map<String, Object> dsMap) {
        DruidDataSource defaultDataSource = new DruidDataSource();
        TransformedMap.transformedMap(dsMap, propertyName -> "druid." + StringExtUtils.toCamel(propertyName, "-", false), propertyValue -> ConvertExtUtils.convert(String.class, propertyValue));
        defaultDataSource.configFromPropety(MapExtUtils.toProperties(dsMap));
        return defaultDataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map druidDsMap;
        DynamicDataSourceContext dynamicDataSourceContext = DynamicDataSourceContext.getInstance();
        Binder binder = Binder.get((Environment)applicationContext.getEnvironment());
        Map<String, Object> defaultDsMap = this.getPropertiesMap(binder, DEFAULT_DATASOURCE_PROPERTY_PREFIX);
        if (defaultDsMap == null) {
            throw new IllegalArgumentException("Missing property [spring.datasource]");
        }
        if (defaultDsMap.containsKey("url") && defaultDsMap.containsKey("username") && defaultDsMap.containsKey("password")) {
            dynamicDataSourceContext.add(DEFAULT_DATASOURCE_NAME, (DataSource)this.createDruidDataSource(defaultDsMap), true);
        }
        if (defaultDsMap.containsKey("druid") && (druidDsMap = (Map)defaultDsMap.get("druid")).containsKey("url") && druidDsMap.containsKey("username") && druidDsMap.containsKey("password")) {
            dynamicDataSourceContext.add(DEFAULT_DATASOURCE_NAME, (DataSource)this.createDruidDataSource(druidDsMap), true);
        }
        if (!defaultDsMap.containsKey("dynamic")) {
            throw new IllegalArgumentException("Missing property [spring.datasource.dynamic]");
        }
        Map dynamicDsMap = (Map)defaultDsMap.get("dynamic");
        this.logger.debug("Find {} datasource!", (Object)(dynamicDsMap == null ? 0 : dynamicDsMap.size()));
        dynamicDsMap.forEach((dsName, dsProperies) -> {
            Map dsPropertiesMap = (Map)dsProperies;
            boolean isPrimary = ConvertExtUtils.convert(Boolean.class, (Object)dsPropertiesMap.getOrDefault("primary", false));
            dynamicDataSourceContext.add((String)dsName, (DataSource)this.createDruidDataSource(dsPropertiesMap), isPrimary);
        });
    }

    @Bean
    public AnnotationDynamicDataSourceAspect annotationDynamicDataSourceAspect() {
        return new AnnotationDynamicDataSourceAspect();
    }
}

