/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.mybatis.dynamic.aop;

import cn.chenzw.toolkit.mybatis.dynamic.support.DynamicDataSource;
import cn.chenzw.toolkit.mybatis.dynamic.support.DynamicDataSourceHolder;
import cn.chenzw.toolkit.mybatis.dynamic.util.SqlMapperUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicDataSourceAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void before(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        System.out.println(method);
        Optional<DynamicDataSource> dataSourceOptl = this.findAnnotation(method, DynamicDataSource.class);
        if (!dataSourceOptl.isPresent() && DynamicDataSourceHolder.get() == null) {
            dataSourceOptl = SqlMapperUtils.getProxyTargetAnnotation(joinPoint.getTarget(), DynamicDataSource.class);
        }
        if (dataSourceOptl.isPresent()) {
            System.out.println(method + "use" + dataSourceOptl.get().value());
            this.logger.debug("[{}] use [{}] dataSource ", (Object)method, (Object)dataSourceOptl.get().value());
            DynamicDataSourceHolder.set(dataSourceOptl.get().value());
        }
    }

    public void after(JoinPoint point) {
        DynamicDataSourceHolder.clear();
    }

    private <T extends Annotation> Optional<T> findAnnotation(Method method, Class<T> annotationClass) {
        if (method.isAnnotationPresent(annotationClass)) {
            return Optional.of(method.getAnnotation(annotationClass));
        }
        if (method.getDeclaringClass().isAnnotationPresent(annotationClass)) {
            return Optional.of(method.getDeclaringClass().getAnnotation(annotationClass));
        }
        return Optional.empty();
    }
}

